/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.architecture.dependency;

import java.time.temporal.ChronoUnit;
import kieker.analysis.generic.graph.INode;
import kieker.analysis.util.time.ChronoUnitToSymbolMapper;
import kieker.model.analysismodel.statistics.StatisticRecord;
import kieker.model.analysismodel.statistics.StatisticsModel;

public class ResponseTimeDecorator {
    private final StatisticsModel statisticsModel;
    private final String timeUnit;

    public ResponseTimeDecorator(StatisticsModel statisticsModel, ChronoUnit chronoUnit) {
        this.statisticsModel = statisticsModel;
        this.timeUnit = ChronoUnitToSymbolMapper.create().apply(chronoUnit);
    }

    public void decorate(INode vertex, Object object) {
        vertex.setPropertyIfAbsent("min response time", this.getStatisticValue(object, "min response time"));
        vertex.setPropertyIfAbsent("max response time", this.getStatisticValue(object, "max response time"));
        vertex.setPropertyIfAbsent("total response time", this.getStatisticValue(object, "total response time"));
        vertex.setPropertyIfAbsent("mean response time", this.getStatisticValue(object, "mean response time"));
        vertex.setPropertyIfAbsent("median response time", this.getStatisticValue(object, "median response time"));
        vertex.setPropertyIfAbsent("time unit", this.timeUnit);
    }

    private long getStatisticValue(Object object, String property) {
        Long value;
        if (this.statisticsModel.getStatistics().containsKey(object) && (value = (Long)((StatisticRecord)this.statisticsModel.getStatistics().get(object)).getProperties().get((Object)property)) != null) {
            return value;
        }
        return 0L;
    }
}

