/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.architecture.dependency;

import kieker.analysis.architecture.dependency.AbstractDependencyGraphBuilder;
import kieker.analysis.architecture.dependency.VertexType;
import kieker.analysis.generic.graph.IEdge;
import kieker.analysis.generic.graph.IGraph;
import kieker.analysis.generic.graph.INode;
import kieker.analysis.util.FullyQualifiedNamesFactory;
import kieker.model.analysismodel.deployment.DeployedOperation;
import kieker.model.analysismodel.type.ComponentType;
import kieker.model.analysismodel.type.OperationType;

public class TypeLevelOperationDependencyGraphBuilder
extends AbstractDependencyGraphBuilder {
    @Override
    protected INode addVertex(DeployedOperation deployedOperation) {
        OperationType operation = deployedOperation.getAssemblyOperation().getOperationType();
        ComponentType component = operation.getComponentType();
        INode componentVertex = this.addVertexIfAbsent(this.graph, FullyQualifiedNamesFactory.createFullyQualifiedName(component));
        componentVertex.setPropertyIfAbsent("type", (Object)VertexType.COMPONENT_TYPE);
        componentVertex.setPropertyIfAbsent("name", component.getName());
        componentVertex.setPropertyIfAbsent("package name", component.getPackage());
        IGraph<INode, IEdge> componentSubgraph = this.addChildGraphIfAbsent(componentVertex);
        INode operationVertex = this.addVertexIfAbsent(componentSubgraph, FullyQualifiedNamesFactory.createFullyQualifiedName(operation));
        operationVertex.setPropertyIfAbsent("type", (Object)VertexType.OPERATION_TYPE);
        operationVertex.setPropertyIfAbsent("name", operation.getName());
        operationVertex.setPropertyIfAbsent("return type", operation.getReturnType());
        operationVertex.setPropertyIfAbsent("modifiers", operation.getModifiers());
        operationVertex.setPropertyIfAbsent("parameter types", operation.getParameterTypes());
        this.responseTimeDecorator.decorate(operationVertex, operation);
        return operationVertex;
    }
}

