/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.architecture.dependency.export.dot;

import java.util.Collection;
import kieker.analysis.architecture.dependency.IVertexTypeMapper;
import kieker.analysis.architecture.dependency.VertexType;
import kieker.analysis.architecture.recovery.signature.NameBuilder;
import kieker.analysis.generic.graph.IEdge;
import kieker.analysis.generic.graph.IElement;
import kieker.analysis.generic.graph.INode;
import kieker.analysis.generic.sink.graph.dot.DotExportBuilder;
import kieker.analysis.generic.sink.graph.dot.DotExportMapper;
import kieker.analysis.generic.sink.graph.dot.attributes.DotClusterAttribute;
import kieker.analysis.generic.sink.graph.dot.attributes.DotEdgeAttribute;
import kieker.analysis.generic.sink.graph.dot.attributes.DotGraphAttribute;
import kieker.analysis.generic.sink.graph.dot.attributes.DotNodeAttribute;

public class DotExportDependencyGraphFactory {
    private static final String ENTRY_LABEL = "'Entry'";
    private final NameBuilder nameBuilder;
    private final IVertexTypeMapper vertexTypeMapper;

    public DotExportDependencyGraphFactory(NameBuilder nameBuilder) {
        this(nameBuilder, IVertexTypeMapper.TO_STRING);
    }

    public DotExportDependencyGraphFactory(NameBuilder nameBuilder, IVertexTypeMapper vertexTypeMapper) {
        this.nameBuilder = nameBuilder;
        this.vertexTypeMapper = vertexTypeMapper;
    }

    private DotExportBuilder<INode, IEdge> createBaseBuilder() {
        DotExportBuilder<INode, IEdge> builder = new DotExportBuilder<INode, IEdge>();
        builder.addGraphAttribute(DotGraphAttribute.RANKDIR, g -> "LR");
        builder.addDefaultEdgeAttribute(DotEdgeAttribute.STYLE, g -> "solid");
        builder.addDefaultEdgeAttribute(DotEdgeAttribute.ARROWHEAD, g -> "open");
        builder.addDefaultEdgeAttribute(DotEdgeAttribute.COLOR, g -> "#000000");
        builder.addDefaultNodeAttribute(DotNodeAttribute.STYLE, g -> "filled");
        builder.addDefaultNodeAttribute(DotNodeAttribute.COLOR, g -> "#000000");
        builder.addDefaultNodeAttribute(DotNodeAttribute.FILLCOLOR, g -> "white");
        builder.addEdgeAttribute(DotEdgeAttribute.LABEL, e -> this.getProperty((IElement)e, "calls").toString());
        builder.addClusterAttribute(DotClusterAttribute.STYLE, v -> "filled");
        builder.addClusterAttribute(DotClusterAttribute.FILLCOLOR, v -> "white");
        return builder;
    }

    public DotExportMapper<INode, IEdge> createForTypeLevelOperationDependencyGraph() {
        DotExportBuilder<INode, IEdge> builder = this.createBaseBuilder();
        builder.addDefaultNodeAttribute(DotNodeAttribute.SHAPE, v -> "oval");
        builder.addNodeAttribute(DotNodeAttribute.LABEL, v -> {
            VertexType type = this.getProperty((IElement)v, "type", (Class)VertexType.class);
            if (type == VertexType.ENTRY) {
                return ENTRY_LABEL;
            }
            return this.createOperationLabelFromVertex((INode)v) + System.lineSeparator() + this.createStatisticsFromVertex((INode)v);
        });
        builder.addClusterAttribute(DotClusterAttribute.LABEL, v -> this.createComponentLabelFromVertex((INode)v).toString());
        return builder.build();
    }

    public DotExportMapper<INode, IEdge> createForTypeLevelComponentDependencyGraph() {
        DotExportBuilder<INode, IEdge> builder = this.createBaseBuilder();
        builder.addDefaultNodeAttribute(DotNodeAttribute.SHAPE, v -> "box");
        builder.addNodeAttribute(DotNodeAttribute.LABEL, v -> {
            VertexType type = this.getProperty((IElement)v, "type", (Class)VertexType.class);
            if (type == VertexType.ENTRY) {
                return ENTRY_LABEL;
            }
            return this.createComponentLabelFromVertex((INode)v) + System.lineSeparator() + this.createStatisticsFromVertex((INode)v);
        });
        return builder.build();
    }

    public DotExportMapper<INode, IEdge> createForAssemblyLevelOperationDependencyGraph() {
        DotExportBuilder<INode, IEdge> builder = this.createBaseBuilder();
        builder.addDefaultNodeAttribute(DotNodeAttribute.SHAPE, v -> "oval");
        builder.addNodeAttribute(DotNodeAttribute.LABEL, v -> {
            VertexType type = this.getProperty((IElement)v, "type", (Class)VertexType.class);
            if (type == VertexType.ENTRY) {
                return ENTRY_LABEL;
            }
            return this.createOperationLabelFromVertex((INode)v) + "\\n" + this.createStatisticsFromVertex((INode)v);
        });
        builder.addClusterAttribute(DotClusterAttribute.LABEL, v -> this.createComponentLabelFromVertex((INode)v).toString());
        return builder.build();
    }

    public DotExportMapper<INode, IEdge> createForAssemblyLevelComponentDependencyGraph() {
        DotExportBuilder<INode, IEdge> builder = this.createBaseBuilder();
        builder.addDefaultNodeAttribute(DotNodeAttribute.SHAPE, v -> "box");
        builder.addNodeAttribute(DotNodeAttribute.LABEL, v -> {
            VertexType type = this.getProperty((IElement)v, "type", (Class)VertexType.class);
            if (type == VertexType.ENTRY) {
                return ENTRY_LABEL;
            }
            return this.createComponentLabelFromVertex((INode)v) + System.lineSeparator() + this.createStatisticsFromVertex((INode)v);
        });
        return builder.build();
    }

    public DotExportMapper<INode, IEdge> createForDeploymentLevelOperationDependencyGraph() {
        DotExportBuilder<INode, IEdge> builder = this.createBaseBuilder();
        builder.addDefaultNodeAttribute(DotNodeAttribute.SHAPE, v -> "oval");
        builder.addNodeAttribute(DotNodeAttribute.LABEL, v -> {
            VertexType type = this.getProperty((IElement)v, "type", (Class)VertexType.class);
            if (type == VertexType.ENTRY) {
                return ENTRY_LABEL;
            }
            return this.createOperationLabelFromVertex((INode)v) + System.lineSeparator() + this.createStatisticsFromVertex((INode)v);
        });
        builder.addClusterAttribute(DotClusterAttribute.LABEL, v -> {
            VertexType type = this.getProperty((IElement)v, "type", (Class)VertexType.class);
            switch (type) {
                case DEPLOYMENT_CONTEXT: {
                    return this.createContextLabelFromVertex((INode)v).toString();
                }
                case DEPLOYED_COMPONENT: {
                    return this.createComponentLabelFromVertex((INode)v).toString();
                }
            }
            throw new IllegalArgumentException("Type '" + type.toString() + "' is not supported for this dependency graph.");
        });
        return builder.build();
    }

    public DotExportMapper<INode, IEdge> createForDeploymentLevelComponentDependencyGraph() {
        DotExportBuilder<INode, IEdge> builder = this.createBaseBuilder();
        builder.addDefaultNodeAttribute(DotNodeAttribute.SHAPE, v -> "box");
        builder.addNodeAttribute(DotNodeAttribute.LABEL, v -> {
            VertexType type = this.getProperty((IElement)v, "type", (Class)VertexType.class);
            if (type == VertexType.ENTRY) {
                return ENTRY_LABEL;
            }
            return this.createComponentLabelFromVertex((INode)v) + System.lineSeparator() + this.createStatisticsFromVertex((INode)v);
        });
        builder.addClusterAttribute(DotClusterAttribute.LABEL, v -> this.createContextLabelFromVertex((INode)v).toString());
        return builder.build();
    }

    public DotExportMapper<INode, IEdge> createForDeploymentLevelContextDependencyGraph() {
        DotExportBuilder<INode, IEdge> builder = this.createBaseBuilder();
        builder.addDefaultNodeAttribute(DotNodeAttribute.SHAPE, v -> "box3d");
        builder.addNodeAttribute(DotNodeAttribute.LABEL, v -> {
            VertexType type = this.getProperty((IElement)v, "type", (Class)VertexType.class);
            if (type == VertexType.ENTRY) {
                return ENTRY_LABEL;
            }
            return this.createContextLabelFromVertex((INode)v).toString();
        });
        return builder.build();
    }

    private StringBuilder createType(VertexType type) {
        return new StringBuilder().append("<<").append((String)this.vertexTypeMapper.apply(type)).append(">>");
    }

    private StringBuilder createOperationLabelFromVertex(INode vertex) {
        Collection modifiers = this.getProperty(vertex, "modifiers", Collection.class);
        String returnType = this.getProperty(vertex, "return type", String.class);
        String name = this.getProperty(vertex, "name", String.class);
        Collection parameterTypes = this.getProperty(vertex, "parameter types", Collection.class);
        return new StringBuilder(this.nameBuilder.getOperationNameBuilder().build(modifiers, returnType, name, parameterTypes));
    }

    private StringBuilder createComponentLabelFromVertex(INode vertex) {
        VertexType type = this.getProperty(vertex, "type", VertexType.class);
        String name = this.getProperty(vertex, "name", String.class);
        String packageName = this.getProperty(vertex, "package name", String.class);
        return new StringBuilder().append((CharSequence)this.createType(type)).append(System.lineSeparator()).append(this.nameBuilder.getComponentNameBuilder().build(packageName, name));
    }

    private StringBuilder createContextLabelFromVertex(INode vertex) {
        VertexType type = this.getProperty(vertex, "type", VertexType.class);
        String name = this.getProperty(vertex, "name", String.class);
        return new StringBuilder().append((CharSequence)this.createType(type)).append(System.lineSeparator()).append(name);
    }

    private StringBuilder createStatisticsFromVertex(INode vertex) {
        String timeUnit = this.getProperty(vertex, "time unit").toString();
        String minResponseTime = this.getProperty(vertex, "min response time").toString();
        String maxResponseTime = this.getProperty(vertex, "max response time").toString();
        String totalResponseTime = this.getProperty(vertex, "total response time").toString();
        String meanResponseTime = this.getProperty(vertex, "mean response time").toString();
        String medianResponseTime = this.getProperty(vertex, "median response time").toString();
        return this.createStatistics(timeUnit, minResponseTime, maxResponseTime, totalResponseTime, meanResponseTime, medianResponseTime);
    }

    private StringBuilder createStatistics(String timeUnit, String minResponseTime, String maxResponseTime, String totalResponseTime, String meanResponseTime, String medianResponseTime) {
        return new StringBuilder().append("min: ").append(minResponseTime).append(' ').append(timeUnit).append(", ").append("max: ").append(maxResponseTime).append(' ').append(timeUnit).append(", ").append("total: ").append(totalResponseTime).append(' ').append(timeUnit).append(',').append(System.lineSeparator()).append("avg: ").append(meanResponseTime).append(' ').append(timeUnit).append(", ").append("median: ").append(medianResponseTime).append(' ').append(timeUnit);
    }

    private Object getProperty(IElement element, String key) {
        Object object = element.getProperty(key);
        if (object == null) {
            throw new IllegalArgumentException("There is no key '" + key + "' for element '" + element + "'");
        }
        return object;
    }

    private <T> T getProperty(IElement element, String key, Class<T> clazz) {
        Object object = this.getProperty(element, key);
        if (!clazz.isInstance(object)) {
            throw new IllegalArgumentException("Object with key '" + key + "' is not of type '" + clazz + "'");
        }
        return clazz.cast(object);
    }
}

