/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.architecture.recovery;

import java.util.Map;
import java.util.function.Function;
import kieker.analysis.architecture.recovery.events.DeployedOperationCallEvent;
import kieker.analysis.statistics.StatisticsDecoratorStage;
import kieker.analysis.statistics.calculating.CountCalculator;
import kieker.model.analysismodel.deployment.DeployedOperation;
import kieker.model.analysismodel.execution.ExecutionModel;
import kieker.model.analysismodel.execution.Invocation;
import kieker.model.analysismodel.execution.Tuple;
import kieker.model.analysismodel.statistics.StatisticsModel;
import org.eclipse.emf.ecore.EObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountUniqueCallsStage
extends StatisticsDecoratorStage<DeployedOperationCallEvent> {
    public CountUniqueCallsStage(StatisticsModel statisticsModel, ExecutionModel executionModel) {
        super(statisticsModel, new CountCalculator("calls"), CountUniqueCallsStage.createForInvocation(executionModel));
    }

    private static Function<DeployedOperationCallEvent, EObject> createForInvocation(ExecutionModel executionModel) {
        return operationCall -> {
            Invocation result = CountUniqueCallsStage.getValue(executionModel, operationCall.getOperationCall());
            if (result == null) {
                Logger logger = LoggerFactory.getLogger(CountUniqueCallsStage.class);
                logger.error("Fatal error: call not does not exist {}:{}", (Object)operationCall.getOperationCall().getFirst().getAssemblyOperation().getOperationType().getSignature(), (Object)operationCall.getOperationCall().getSecond().getAssemblyOperation().getOperationType().getSignature());
            }
            return result;
        };
    }

    private static Invocation getValue(ExecutionModel executionModel, Tuple<DeployedOperation, DeployedOperation> key) {
        for (Map.Entry ag : executionModel.getInvocations()) {
            if (((Tuple)ag.getKey()).hashCode() != key.hashCode()) continue;
            return (Invocation)ag.getValue();
        }
        return null;
    }
}

