/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.architecture.recovery;

import java.io.PrintStream;
import kieker.model.analysismodel.deployment.DeployedComponent;
import kieker.model.analysismodel.deployment.DeployedOperation;
import kieker.model.analysismodel.deployment.DeploymentContext;
import kieker.model.analysismodel.deployment.DeploymentModel;

public class DeploymentModelPrinter {
    private static final String INSERTION = "    ";
    private final PrintStream printStream;

    public DeploymentModelPrinter(PrintStream printStream) {
        this.printStream = printStream;
    }

    public void print(DeploymentModel model) {
        for (DeploymentContext deploymentContext : model.getContexts().values()) {
            this.printDeploymentContext(deploymentContext);
            for (DeployedComponent component : deploymentContext.getComponents().values()) {
                this.printComponent(component);
                for (DeployedOperation operation : component.getOperations().values()) {
                    this.printOperation(operation);
                }
            }
        }
    }

    private void printDeploymentContext(DeploymentContext deploymentContext) {
        String name = deploymentContext.getName();
        this.printStream.println(name);
    }

    private void printComponent(DeployedComponent component) {
        String name = component.getAssemblyComponent().getComponentType().getSignature();
        this.printStream.println(INSERTION + name);
    }

    private void printOperation(DeployedOperation operation) {
        String name = operation.getAssemblyOperation().getOperationType().getSignature();
        this.printStream.println("        " + name);
    }
}

