/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.architecture.recovery;

import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import kieker.analysis.architecture.recovery.events.CallEvent;
import kieker.analysis.architecture.recovery.events.OperationEvent;
import kieker.analysis.architecture.recovery.signature.AbstractSignatureProcessor;
import kieker.analysis.architecture.recovery.signature.NullSignatureProcessor;
import kieker.common.record.flow.IFlowRecord;
import kieker.common.record.flow.trace.TraceMetadata;
import kieker.common.record.flow.trace.operation.AfterOperationEvent;
import kieker.common.record.flow.trace.operation.AfterOperationFailedEvent;
import kieker.common.record.flow.trace.operation.BeforeOperationEvent;
import kieker.common.record.flow.trace.operation.CallOperationEvent;
import teetime.framework.AbstractConsumerStage;
import teetime.framework.OutputPort;

public class OperationAndCallGeneratorStage
extends AbstractConsumerStage<IFlowRecord> {
    private final Map<Long, TraceData> traceDataMap = new ConcurrentHashMap<Long, TraceData>();
    private final OutputPort<OperationEvent> operationOutputPort = this.createOutputPort(OperationEvent.class);
    private final OutputPort<CallEvent> callOutputPort = this.createOutputPort(CallEvent.class);
    private final boolean createEntryCall;
    private final AbstractSignatureProcessor processor;

    public OperationAndCallGeneratorStage(boolean createEntryCall, AbstractSignatureProcessor processor) {
        this.createEntryCall = createEntryCall;
        this.processor = processor;
    }

    public OperationAndCallGeneratorStage(boolean createEntryCall) {
        this(createEntryCall, new NullSignatureProcessor(false));
    }

    protected void execute(IFlowRecord element) {
        if (element instanceof TraceMetadata) {
            this.processTraceMetadata((TraceMetadata)element);
        } else if (element instanceof BeforeOperationEvent) {
            this.processBeforeOperationEvent((BeforeOperationEvent)element);
        } else if (element instanceof AfterOperationFailedEvent) {
            this.processAfterOperationFailedEvent((AfterOperationFailedEvent)element);
        } else if (element instanceof AfterOperationEvent) {
            this.processAfterOperationEvent((AfterOperationEvent)element);
        } else if (element instanceof CallOperationEvent) {
            this.logger.error("Received CallOperationEvent which cannot be handled by the {}. Sanitize the trace before processing it.", (Object)((Object)((Object)this)).getClass().getSimpleName());
        }
    }

    private void processTraceMetadata(TraceMetadata traceMetadata) {
        this.traceDataMap.put(traceMetadata.getTraceId(), new TraceData(traceMetadata, new Stack<OperationEvent>()));
    }

    private void processBeforeOperationEvent(BeforeOperationEvent beforeOperationEvent) {
        TraceData traceData = this.traceDataMap.get(beforeOperationEvent.getTraceId());
        this.processor.processSignatures(beforeOperationEvent.getClassSignature(), beforeOperationEvent.getOperationSignature());
        OperationEvent newEvent = new OperationEvent(traceData.getMetadata().getHostname(), this.processor.getComponentSignature(), this.processor.getOperationSignature());
        if (!traceData.getOperationStack().empty()) {
            this.operationOutputPort.send((Object)newEvent);
        } else if (this.createEntryCall) {
            OperationEvent triggerEvent = new OperationEvent("external", "<unknown>", "<unknown>");
            this.operationOutputPort.send((Object)triggerEvent);
            this.operationOutputPort.send((Object)newEvent);
            traceData.getOperationStack().push(triggerEvent);
            traceData.getStartTimeStack().push(Instant.ofEpochSecond(0L, beforeOperationEvent.getTimestamp()));
        } else {
            this.operationOutputPort.send((Object)newEvent);
        }
        traceData.getOperationStack().push(newEvent);
        traceData.getStartTimeStack().push(Instant.ofEpochSecond(0L, beforeOperationEvent.getTimestamp()));
    }

    private void processAfterOperationEvent(AfterOperationEvent afterOperationEvent) {
        TraceData traceData = this.traceDataMap.get(afterOperationEvent.getTraceId());
        Stack<OperationEvent> stack = traceData.getOperationStack();
        if (!stack.isEmpty()) {
            OperationEvent lastEvent = stack.pop();
            this.processor.processSignatures(afterOperationEvent.getClassSignature(), afterOperationEvent.getOperationSignature());
            if (!lastEvent.getComponentSignature().equals(this.processor.getComponentSignature()) || !lastEvent.getOperationSignature().equals(this.processor.getOperationSignature())) {
                this.logger.error("Broken trace, expected {}:{}, but got {}:{}", new Object[]{lastEvent.getComponentSignature(), lastEvent.getOperationSignature(), this.processor.getComponentSignature(), this.processor.getOperationSignature()});
            }
            if (stack.isEmpty()) {
                this.traceDataMap.remove(afterOperationEvent.getTraceId());
            } else {
                OperationEvent previousEvent = stack.peek();
                Instant end = Instant.ofEpochSecond(0L, afterOperationEvent.getTimestamp());
                this.callOutputPort.send((Object)new CallEvent(previousEvent, lastEvent, Duration.between(traceData.getStartTimeStack().pop(), end)));
            }
        } else {
            this.logger.error("Trace stack error. AfterOperationEvent without a previous BeforeOperationEvent, found {}:{}", (Object)afterOperationEvent.getClassSignature(), (Object)afterOperationEvent.getOperationSignature());
        }
    }

    private void processAfterOperationFailedEvent(AfterOperationFailedEvent afterOperationFailedEvent) {
        TraceData traceData = this.traceDataMap.get(afterOperationFailedEvent.getTraceId());
        Stack<OperationEvent> stack = traceData.getOperationStack();
        if (!stack.isEmpty()) {
            OperationEvent lastEvent = stack.pop();
            if (!stack.isEmpty()) {
                OperationEvent previousEvent = stack.peek();
                Instant end = Instant.ofEpochSecond(0L, afterOperationFailedEvent.getTimestamp());
                this.callOutputPort.send((Object)new CallEvent(previousEvent, lastEvent, Duration.between(traceData.getStartTimeStack().pop(), end)));
            }
        }
        this.traceDataMap.remove(afterOperationFailedEvent.getTraceId());
    }

    public OutputPort<CallEvent> getCallOutputPort() {
        return this.callOutputPort;
    }

    public OutputPort<OperationEvent> getOperationOutputPort() {
        return this.operationOutputPort;
    }

    private final class TraceData {
        private final TraceMetadata metadata;
        private final Stack<OperationEvent> operationStack;
        private final Stack<Instant> startTimeStack;

        private TraceData(TraceMetadata metadata, Stack<OperationEvent> operationStack) {
            this.metadata = metadata;
            this.operationStack = operationStack;
            this.startTimeStack = new Stack();
        }

        public TraceMetadata getMetadata() {
            return this.metadata;
        }

        public Stack<OperationEvent> getOperationStack() {
            return this.operationStack;
        }

        public Stack<Instant> getStartTimeStack() {
            return this.startTimeStack;
        }
    }
}

