/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.architecture.recovery;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kieker.common.record.flow.IFlowRecord;
import kieker.common.record.flow.trace.TraceMetadata;
import kieker.common.record.flow.trace.operation.AbstractOperationEvent;
import kieker.common.record.flow.trace.operation.AfterOperationEvent;
import kieker.common.record.flow.trace.operation.BeforeOperationEvent;
import kieker.model.analysismodel.deployment.DeployedComponent;
import kieker.model.analysismodel.deployment.DeployedOperation;
import kieker.model.analysismodel.deployment.DeploymentContext;
import kieker.model.analysismodel.deployment.DeploymentModel;
import teetime.stage.basic.AbstractFilter;

public class OperationPresentInModelEventReleaseControlStage
extends AbstractFilter<IFlowRecord> {
    private final DeploymentModel deploymentModel;
    private final List<AbstractOperationEvent> events = new ArrayList<AbstractOperationEvent>();
    private final Map<Long, TraceMetadata> traceMetadataMap = new ConcurrentHashMap<Long, TraceMetadata>();
    private final Map<Long, Long> traceOrderIndexMap = new ConcurrentHashMap<Long, Long>();

    public OperationPresentInModelEventReleaseControlStage(DeploymentModel deploymentModel) {
        this.deploymentModel = deploymentModel;
    }

    protected void execute(IFlowRecord element) throws Exception {
        if (element instanceof AbstractOperationEvent) {
            this.storeEvent((AbstractOperationEvent)element);
            this.sendEvent();
        } else {
            if (element instanceof TraceMetadata) {
                TraceMetadata metadata = (TraceMetadata)element;
                this.traceMetadataMap.put(metadata.getTraceId(), metadata);
                this.traceOrderIndexMap.put(metadata.getTraceId(), 0L);
            }
            this.sendEvent();
            this.outputPort.send((Object)element);
        }
    }

    private void sendEvent() {
        AbstractOperationEvent event;
        if (!this.events.isEmpty() && this.operationExists(event = this.events.get(0))) {
            this.outputPort.send((Object)event);
            this.events.remove(0);
            this.sendEvent();
            if (this.traceOrderIndexMap.get(event.getTraceId()) == 0L) {
                this.traceMetadataMap.remove(event.getTraceId());
            }
        }
    }

    private boolean operationExists(AbstractOperationEvent event) {
        DeployedComponent component;
        TraceMetadata metadata = this.traceMetadataMap.get(event.getTraceId());
        DeploymentContext context = (DeploymentContext)this.deploymentModel.getContexts().get((Object)metadata.getHostname());
        if (context != null && (component = (DeployedComponent)context.getComponents().get((Object)event.getClassSignature())) != null) {
            DeployedOperation operation = (DeployedOperation)component.getOperations().get((Object)event.getOperationSignature());
            return operation != null;
        }
        return false;
    }

    private void storeEvent(AbstractOperationEvent element) {
        if (element instanceof BeforeOperationEvent) {
            Long value = this.traceOrderIndexMap.get(element.getTraceId()) + 1L;
            this.traceOrderIndexMap.put(element.getTraceId(), value);
        } else if (element instanceof AfterOperationEvent) {
            Long value = this.traceOrderIndexMap.get(element.getTraceId()) - 1L;
            this.traceOrderIndexMap.put(element.getTraceId(), value);
        }
        this.events.add(element);
    }
}

