/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.architecture.recovery.assembler;

import kieker.analysis.architecture.recovery.assembler.AbstractModelAssembler;
import kieker.analysis.architecture.recovery.events.DeployedOperationCallEvent;
import kieker.model.analysismodel.execution.ExecutionFactory;
import kieker.model.analysismodel.execution.ExecutionModel;
import kieker.model.analysismodel.execution.Invocation;
import kieker.model.analysismodel.source.SourceModel;

public class InvocationExecutionModelAssembler
extends AbstractModelAssembler<DeployedOperationCallEvent> {
    private final ExecutionFactory factory = ExecutionFactory.eINSTANCE;
    private final ExecutionModel executionModel;

    public InvocationExecutionModelAssembler(ExecutionModel executionModel, SourceModel sourceModel, String sourceLabel) {
        super(sourceModel, sourceLabel);
        this.executionModel = executionModel;
    }

    @Override
    public void assemble(DeployedOperationCallEvent operationCall) {
        if (!this.executionModel.getInvocations().containsKey(operationCall.getOperationCall())) {
            Invocation invocation = this.factory.createInvocation();
            invocation.setCaller(operationCall.getOperationCall().getFirst());
            invocation.setCallee(operationCall.getOperationCall().getSecond());
            this.updateSourceModel(invocation);
            this.executionModel.getInvocations().put(operationCall.getOperationCall(), (Object)invocation);
        }
    }
}

