/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.architecture.recovery.assembler;

import kieker.analysis.architecture.recovery.assembler.AbstractModelAssembler;
import kieker.analysis.architecture.recovery.events.OperationEvent;
import kieker.model.analysismodel.assembly.AssemblyComponent;
import kieker.model.analysismodel.assembly.AssemblyFactory;
import kieker.model.analysismodel.assembly.AssemblyModel;
import kieker.model.analysismodel.assembly.AssemblyOperation;
import kieker.model.analysismodel.source.SourceModel;
import kieker.model.analysismodel.type.ComponentType;
import kieker.model.analysismodel.type.OperationType;
import kieker.model.analysismodel.type.TypeModel;

public class OperationAssemblyModelAssembler
extends AbstractModelAssembler<OperationEvent> {
    private final AssemblyFactory factory = AssemblyFactory.eINSTANCE;
    private final TypeModel typeModel;
    private final AssemblyModel assemblyModel;

    public OperationAssemblyModelAssembler(TypeModel typeModel, AssemblyModel assemblyModel, SourceModel sourceModel, String sourceLabel) {
        super(sourceModel, sourceLabel);
        this.typeModel = typeModel;
        this.assemblyModel = assemblyModel;
    }

    @Override
    public void assemble(OperationEvent event) {
        String componentSignature = event.getComponentSignature();
        String operationSignature = event.getOperationSignature();
        this.addOperation(componentSignature, operationSignature);
    }

    public void addOperation(String componentSignature, String operationSignature) {
        AssemblyComponent component = this.addAssemblyComponent(componentSignature);
        this.addAssemblyOperation(component, operationSignature);
    }

    private AssemblyComponent addAssemblyComponent(String componentSignature) {
        String componentKey = componentSignature;
        AssemblyComponent component = (AssemblyComponent)this.assemblyModel.getComponents().get((Object)componentKey);
        if (component == null) {
            component = this.factory.createAssemblyComponent();
            this.assemblyModel.getComponents().put((Object)componentKey, (Object)component);
            String componentTypeKey = componentSignature;
            ComponentType componentType = (ComponentType)this.typeModel.getComponentTypes().get((Object)componentTypeKey);
            component.setComponentType(componentType);
            component.setSignature(componentSignature);
        }
        this.updateSourceModel(component);
        return component;
    }

    private AssemblyOperation addAssemblyOperation(AssemblyComponent component, String operationSignature) {
        String operationKey = operationSignature;
        AssemblyOperation operation = (AssemblyOperation)component.getOperations().get((Object)operationKey);
        if (operation == null) {
            operation = this.factory.createAssemblyOperation();
            component.getOperations().put((Object)operationKey, (Object)operation);
            ComponentType componentType = component.getComponentType();
            String operationTypeKey = operationSignature;
            OperationType operationType = (OperationType)componentType.getProvidedOperations().get((Object)operationTypeKey);
            operation.setOperationType(operationType);
        }
        this.updateSourceModel(operation);
        return operation;
    }
}

