/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.architecture.recovery.assembler;

import kieker.analysis.architecture.recovery.assembler.AbstractModelAssembler;
import kieker.analysis.architecture.recovery.events.OperationEvent;
import kieker.model.analysismodel.assembly.AssemblyComponent;
import kieker.model.analysismodel.assembly.AssemblyModel;
import kieker.model.analysismodel.assembly.AssemblyOperation;
import kieker.model.analysismodel.deployment.DeployedComponent;
import kieker.model.analysismodel.deployment.DeployedOperation;
import kieker.model.analysismodel.deployment.DeploymentContext;
import kieker.model.analysismodel.deployment.DeploymentFactory;
import kieker.model.analysismodel.deployment.DeploymentModel;
import kieker.model.analysismodel.source.SourceModel;

public class OperationDeploymentModelAssembler
extends AbstractModelAssembler<OperationEvent> {
    private final DeploymentFactory factory = DeploymentFactory.eINSTANCE;
    private final AssemblyModel assemblyModel;
    private final DeploymentModel deploymentModel;

    public OperationDeploymentModelAssembler(AssemblyModel assemblyModel, DeploymentModel deploymentModel, SourceModel sourceModel, String sourceLabel) {
        super(sourceModel, sourceLabel);
        this.assemblyModel = assemblyModel;
        this.deploymentModel = deploymentModel;
    }

    @Override
    public void assemble(OperationEvent event) {
        String hostname = event.getHostname();
        String classSignature = event.getComponentSignature();
        String operationSignature = event.getOperationSignature();
        this.addOperation(hostname, classSignature, operationSignature);
    }

    private void addOperation(String hostname, String componentSignature, String operationSignature) {
        DeploymentContext deploymentContext = this.findOrAddDeploymentContext(hostname);
        DeployedComponent component = this.findOrAddDeployedComponent(deploymentContext, componentSignature);
        this.addDeployedOperation(component, operationSignature);
    }

    private DeploymentContext findOrAddDeploymentContext(String hostname) {
        String deploymentContextKey = hostname;
        DeploymentContext deploymentContext = (DeploymentContext)this.deploymentModel.getContexts().get((Object)deploymentContextKey);
        if (deploymentContext == null) {
            deploymentContext = this.factory.createDeploymentContext();
            deploymentContext.setName(hostname);
            this.deploymentModel.getContexts().put((Object)deploymentContextKey, (Object)deploymentContext);
        }
        this.updateSourceModel(deploymentContext);
        return deploymentContext;
    }

    private DeployedComponent findOrAddDeployedComponent(DeploymentContext deploymentContext, String componentSignature) {
        DeployedComponent component = (DeployedComponent)deploymentContext.getComponents().get((Object)componentSignature);
        if (component == null) {
            component = this.factory.createDeployedComponent();
            deploymentContext.getComponents().put((Object)componentSignature, (Object)component);
            String componentTypeKey = componentSignature;
            AssemblyComponent assemblyComponent = (AssemblyComponent)this.assemblyModel.getComponents().get((Object)componentTypeKey);
            component.setAssemblyComponent(assemblyComponent);
            component.setSignature(componentSignature);
        }
        this.updateSourceModel(component);
        return component;
    }

    private DeployedOperation addDeployedOperation(DeployedComponent component, String operationSignature) {
        String operationKey = operationSignature;
        DeployedOperation operation = (DeployedOperation)component.getOperations().get((Object)operationKey);
        if (operation == null) {
            operation = this.factory.createDeployedOperation();
            component.getOperations().put((Object)operationKey, (Object)operation);
            AssemblyComponent assemblyComponent = component.getAssemblyComponent();
            String operationTypeKey = operationSignature;
            AssemblyOperation assemblyOperation = (AssemblyOperation)assemblyComponent.getOperations().get((Object)operationTypeKey);
            operation.setAssemblyOperation(assemblyOperation);
        }
        this.updateSourceModel(operation);
        return operation;
    }
}

