/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.architecture.recovery.assembler;

import kieker.analysis.architecture.recovery.assembler.AbstractModelAssembler;
import kieker.analysis.architecture.recovery.events.OperationEvent;
import kieker.analysis.architecture.recovery.signature.IComponentSignatureExtractor;
import kieker.analysis.architecture.recovery.signature.IOperationSignatureExtractor;
import kieker.model.analysismodel.source.SourceModel;
import kieker.model.analysismodel.type.ComponentType;
import kieker.model.analysismodel.type.OperationType;
import kieker.model.analysismodel.type.TypeFactory;
import kieker.model.analysismodel.type.TypeModel;

public class OperationTypeModelAssembler
extends AbstractModelAssembler<OperationEvent> {
    private final TypeFactory factory = TypeFactory.eINSTANCE;
    private final IComponentSignatureExtractor componentSignatureExtractor;
    private final IOperationSignatureExtractor operationSignatureExtractor;
    private final TypeModel typeModel;

    public OperationTypeModelAssembler(TypeModel typeModel, SourceModel sourceModel, String sourceLabel, IComponentSignatureExtractor componentSignatureExtractor, IOperationSignatureExtractor operationSignatureExtractor) {
        super(sourceModel, sourceLabel);
        this.typeModel = typeModel;
        this.componentSignatureExtractor = componentSignatureExtractor;
        this.operationSignatureExtractor = operationSignatureExtractor;
    }

    @Override
    public void assemble(OperationEvent event) {
        String componentSignature = event.getComponentSignature();
        String operationSignature = event.getOperationSignature();
        ComponentType componentType = this.addComponentType(componentSignature);
        this.addOperationType(componentType, operationSignature);
    }

    private ComponentType addComponentType(String componentSignature) {
        String componentTypeKey = componentSignature;
        ComponentType componentType = (ComponentType)this.typeModel.getComponentTypes().get((Object)componentTypeKey);
        if (componentType == null) {
            componentType = this.factory.createComponentType();
            componentType.setSignature(componentSignature);
            this.componentSignatureExtractor.extract(componentType);
            this.typeModel.getComponentTypes().put((Object)componentTypeKey, (Object)componentType);
        }
        this.updateSourceModel(componentType);
        return componentType;
    }

    private OperationType addOperationType(ComponentType componentType, String operationSignature) {
        String operationTypeKey = operationSignature;
        OperationType operationType = (OperationType)componentType.getProvidedOperations().get((Object)operationSignature);
        if (operationType == null) {
            operationType = this.factory.createOperationType();
            operationType.setSignature(operationSignature);
            this.operationSignatureExtractor.extract(operationType);
            componentType.getProvidedOperations().put((Object)operationTypeKey, (Object)operationType);
        }
        this.updateSourceModel(operationType);
        return operationType;
    }
}

