/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.architecture.recovery.assembler;

import kieker.analysis.architecture.recovery.assembler.AbstractModelAssembler;
import kieker.analysis.architecture.recovery.events.StorageEvent;
import kieker.model.analysismodel.assembly.AssemblyComponent;
import kieker.model.analysismodel.assembly.AssemblyFactory;
import kieker.model.analysismodel.assembly.AssemblyModel;
import kieker.model.analysismodel.assembly.AssemblyStorage;
import kieker.model.analysismodel.source.SourceModel;
import kieker.model.analysismodel.type.ComponentType;
import kieker.model.analysismodel.type.StorageType;
import kieker.model.analysismodel.type.TypeModel;

public class StorageAssemblyModelAssembler
extends AbstractModelAssembler<StorageEvent> {
    private final AssemblyModel assemblyModel;
    private final TypeModel typeModel;

    public StorageAssemblyModelAssembler(TypeModel typeModel, AssemblyModel assemblyModel, SourceModel sourceModel, String sourceLabel) {
        super(sourceModel, sourceLabel);
        this.typeModel = typeModel;
        this.assemblyModel = assemblyModel;
    }

    @Override
    public void assemble(StorageEvent event) {
        AssemblyComponent assemblyComponent = this.assemblyComponentSetUp(event);
        this.addStorage(assemblyComponent, event);
    }

    private AssemblyComponent assemblyComponentSetUp(StorageEvent storageEvent) {
        AssemblyComponent assemblyComponent = (AssemblyComponent)this.assemblyModel.getComponents().get((Object)storageEvent.getComponentSignature());
        if (assemblyComponent == null) {
            assemblyComponent = this.createAssemblyComponent(storageEvent.getComponentSignature());
        }
        return assemblyComponent;
    }

    private AssemblyComponent createAssemblyComponent(String assemblyComponentSignature) {
        AssemblyComponent newAssemblyComponent = AssemblyFactory.eINSTANCE.createAssemblyComponent();
        newAssemblyComponent.setComponentType((ComponentType)this.typeModel.getComponentTypes().get((Object)assemblyComponentSignature));
        newAssemblyComponent.setSignature(assemblyComponentSignature);
        this.assemblyModel.getComponents().put((Object)assemblyComponentSignature, (Object)newAssemblyComponent);
        this.updateSourceModel(newAssemblyComponent);
        return newAssemblyComponent;
    }

    private AssemblyStorage addStorage(AssemblyComponent assemblyComponent, StorageEvent event) {
        String storageSignature = event.getStorageSignature();
        AssemblyStorage assemblyStorage = (AssemblyStorage)assemblyComponent.getStorages().get((Object)storageSignature);
        if (assemblyStorage == null) {
            assemblyStorage = AssemblyFactory.eINSTANCE.createAssemblyStorage();
            StorageType storageType = (StorageType)assemblyComponent.getComponentType().getProvidedStorages().get((Object)storageSignature);
            assemblyStorage.setStorageType(storageType);
            assemblyComponent.getStorages().put((Object)storageSignature, (Object)assemblyStorage);
            this.updateSourceModel(assemblyStorage);
        }
        return assemblyStorage;
    }
}

