/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.architecture.recovery.assembler;

import kieker.analysis.architecture.recovery.assembler.AbstractModelAssembler;
import kieker.analysis.architecture.recovery.events.StorageEvent;
import kieker.model.analysismodel.assembly.AssemblyComponent;
import kieker.model.analysismodel.assembly.AssemblyModel;
import kieker.model.analysismodel.assembly.AssemblyStorage;
import kieker.model.analysismodel.deployment.DeployedComponent;
import kieker.model.analysismodel.deployment.DeployedStorage;
import kieker.model.analysismodel.deployment.DeploymentContext;
import kieker.model.analysismodel.deployment.DeploymentFactory;
import kieker.model.analysismodel.deployment.DeploymentModel;
import kieker.model.analysismodel.source.SourceModel;

public class StorageDeploymentModelAssembler
extends AbstractModelAssembler<StorageEvent> {
    private final DeploymentFactory factory = DeploymentFactory.eINSTANCE;
    private final AssemblyModel assemblyModel;
    private final DeploymentModel deploymentModel;

    public StorageDeploymentModelAssembler(AssemblyModel assemblyModel, DeploymentModel deploymentModel, SourceModel sourceModel, String sourceLabel) {
        super(sourceModel, sourceLabel);
        this.assemblyModel = assemblyModel;
        this.deploymentModel = deploymentModel;
    }

    @Override
    public void assemble(StorageEvent event) {
        DeployedComponent deployedComponent = this.deployedComponentSetUp(event);
        this.addStorage(deployedComponent, event);
    }

    private DeployedComponent deployedComponentSetUp(StorageEvent event) {
        DeploymentContext deploymentContext = this.findOrAddDeploymentContext(event.getHostname());
        if (deploymentContext == null) {
            deploymentContext = this.factory.createDeploymentContext();
            deploymentContext.setName(event.getHostname());
            this.deploymentModel.getContexts().put((Object)event.getHostname(), (Object)deploymentContext);
        }
        this.updateSourceModel(deploymentContext);
        DeployedComponent deployedComponent = (DeployedComponent)deploymentContext.getComponents().get((Object)event.getComponentSignature());
        if (deployedComponent == null) {
            deployedComponent = this.createDeployedComponent(deploymentContext, event);
        }
        return deployedComponent;
    }

    private DeploymentContext findOrAddDeploymentContext(String hostname) {
        String deploymentContextKey = hostname;
        DeploymentContext deploymentContext = (DeploymentContext)this.deploymentModel.getContexts().get((Object)deploymentContextKey);
        if (deploymentContext == null) {
            deploymentContext = this.factory.createDeploymentContext();
            deploymentContext.setName(hostname);
            this.deploymentModel.getContexts().put((Object)deploymentContextKey, (Object)deploymentContext);
        }
        this.updateSourceModel(deploymentContext);
        return deploymentContext;
    }

    private DeployedComponent createDeployedComponent(DeploymentContext deploymentContext, StorageEvent event) {
        DeployedComponent newDeployedComponent = DeploymentFactory.eINSTANCE.createDeployedComponent();
        String componentSignature = event.getComponentSignature();
        newDeployedComponent.setSignature(componentSignature);
        newDeployedComponent.setAssemblyComponent((AssemblyComponent)this.assemblyModel.getComponents().get((Object)componentSignature));
        deploymentContext.getComponents().put((Object)componentSignature, (Object)newDeployedComponent);
        this.updateSourceModel(newDeployedComponent);
        return newDeployedComponent;
    }

    private DeployedStorage addStorage(DeployedComponent deployedComponent, StorageEvent event) {
        String storageSignature = event.getStorageSignature();
        DeployedStorage deployedStorage = (DeployedStorage)deployedComponent.getStorages().get((Object)storageSignature);
        if (deployedStorage == null) {
            deployedStorage = DeploymentFactory.eINSTANCE.createDeployedStorage();
            AssemblyStorage assemblyStorage = (AssemblyStorage)deployedComponent.getAssemblyComponent().getStorages().get((Object)storageSignature);
            deployedStorage.setAssemblyStorage(assemblyStorage);
            deployedComponent.getStorages().put((Object)storageSignature, (Object)deployedStorage);
            ((DeploymentContext)this.deploymentModel.getContexts().get((Object)event.getHostname())).getComponents().put((Object)deployedComponent.getSignature(), (Object)deployedComponent);
            this.updateSourceModel(deployedStorage);
        }
        return deployedStorage;
    }
}

