/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.architecture.recovery.assembler;

import kieker.analysis.architecture.recovery.assembler.AbstractModelAssembler;
import kieker.analysis.architecture.recovery.events.StorageEvent;
import kieker.analysis.architecture.recovery.signature.IComponentSignatureExtractor;
import kieker.analysis.architecture.recovery.signature.IStorageSignatureExtractor;
import kieker.model.analysismodel.source.SourceModel;
import kieker.model.analysismodel.type.ComponentType;
import kieker.model.analysismodel.type.StorageType;
import kieker.model.analysismodel.type.TypeFactory;
import kieker.model.analysismodel.type.TypeModel;

public class StorageTypeModelAssembler
extends AbstractModelAssembler<StorageEvent> {
    private final TypeFactory factory = TypeFactory.eINSTANCE;
    private final IComponentSignatureExtractor componentSignatureExtractor;
    private final IStorageSignatureExtractor storageSignatureExtractor;
    private final TypeModel typeModel;

    public StorageTypeModelAssembler(TypeModel typeModel, SourceModel sourceModel, String sourceLabel, IComponentSignatureExtractor componentSignatureExtractor, IStorageSignatureExtractor storageSignatureExtractor) {
        super(sourceModel, sourceLabel);
        this.typeModel = typeModel;
        this.componentSignatureExtractor = componentSignatureExtractor;
        this.storageSignatureExtractor = storageSignatureExtractor;
    }

    @Override
    public void assemble(StorageEvent event) {
        String componentSignature = event.getComponentSignature();
        String operationSignature = event.getStorageSignature();
        ComponentType componentType = this.findOrCreateComponentType(componentSignature);
        this.addStorageType(componentType, operationSignature);
    }

    private ComponentType findOrCreateComponentType(String componentSignature) {
        ComponentType componentType = (ComponentType)this.typeModel.getComponentTypes().get((Object)componentSignature);
        if (componentType == null) {
            componentType = this.factory.createComponentType();
            componentType.setSignature(componentSignature);
            this.componentSignatureExtractor.extract(componentType);
            this.typeModel.getComponentTypes().put((Object)componentSignature, (Object)componentType);
        }
        this.updateSourceModel(componentType);
        return componentType;
    }

    private StorageType addStorageType(ComponentType componentType, String storageSignature) {
        StorageType storageType = (StorageType)componentType.getProvidedStorages().get((Object)storageSignature);
        if (storageType == null) {
            storageType = this.factory.createStorageType();
            storageType.setName(storageSignature);
            storageType.setType("<unknown>");
            this.storageSignatureExtractor.extract(storageType);
            componentType.getProvidedStorages().put((Object)storageSignature, (Object)storageType);
        }
        this.updateSourceModel(storageType);
        return storageType;
    }
}

