/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.architecture.recovery.assembler;

import kieker.analysis.architecture.recovery.assembler.AbstractModelAssembler;
import kieker.model.analysismodel.deployment.DeployedOperation;
import kieker.model.analysismodel.execution.ExecutionFactory;
import kieker.model.analysismodel.execution.ExecutionModel;
import kieker.model.analysismodel.execution.Invocation;
import kieker.model.analysismodel.execution.Tuple;
import kieker.model.analysismodel.source.SourceModel;
import kieker.model.analysismodel.trace.OperationCall;

public class TraceBasedExecutionModelAssembler
extends AbstractModelAssembler<OperationCall> {
    private final ExecutionFactory factory = ExecutionFactory.eINSTANCE;
    private final ExecutionModel executionModel;

    public TraceBasedExecutionModelAssembler(ExecutionModel executionModel, SourceModel sourceModel, String sourceLabel) {
        super(sourceModel, sourceLabel);
        this.executionModel = executionModel;
    }

    @Override
    public void assemble(OperationCall operationCall) {
        DeployedOperation caller = operationCall.getParent() != null ? operationCall.getParent().getOperation() : null;
        DeployedOperation callee = operationCall.getOperation();
        this.addExecution(caller, callee);
    }

    protected void addExecution(DeployedOperation caller, DeployedOperation callee) {
        Tuple<DeployedOperation, DeployedOperation> key = this.factory.createTuple();
        key.setFirst(caller);
        key.setSecond(callee);
        if (!this.executionModel.getInvocations().containsKey(key)) {
            Invocation invocation = this.factory.createInvocation();
            invocation.setCaller(caller);
            invocation.setCallee(callee);
            this.updateSourceModel(invocation);
            this.executionModel.getInvocations().put(key, (Object)invocation);
        }
    }
}

