/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.architecture.recovery.events;

import kieker.analysis.architecture.recovery.events.OperationEvent;

public class GenericElementEvent {
    private final String hostname;
    private final String componentSignature;

    public GenericElementEvent(String hostname, String componentSignature) {
        this.hostname = hostname;
        this.componentSignature = componentSignature;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getComponentSignature() {
        return this.componentSignature;
    }

    public boolean equals(Object obj) {
        if (obj instanceof OperationEvent) {
            OperationEvent operation = (OperationEvent)obj;
            return this.compare(this.componentSignature, operation.getComponentSignature()) && this.compare(this.hostname, operation.getHostname());
        }
        return super.equals(obj);
    }

    private boolean compare(String a, String b) {
        if (a == null && b == null) {
            return true;
        }
        if (a != null) {
            return a.equals(b);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() ^ this.hostname.hashCode() ^ this.componentSignature.hashCode();
    }

    public String toString() {
        return String.format("%s>%s", this.hostname, this.componentSignature);
    }
}

