/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.architecture.recovery.events;

import kieker.analysis.architecture.recovery.events.GenericElementEvent;

public class StorageEvent
extends GenericElementEvent {
    private final String storageSignature;
    private final String storageType;

    public StorageEvent(String hostname, String componentSignature, String storageSignature, String storageType) {
        super(hostname, componentSignature);
        this.storageSignature = storageSignature;
        this.storageType = storageType;
    }

    public String getStorageSignature() {
        return this.storageSignature;
    }

    public String getStorageType() {
        return this.storageType;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof StorageEvent) {
            StorageEvent storage = (StorageEvent)obj;
            return this.compare(this.getComponentSignature(), storage.getComponentSignature()) && this.compare(this.storageSignature, storage.getStorageSignature()) && this.compare(this.storageType, storage.getStorageSignature()) && this.compare(this.getHostname(), storage.getHostname());
        }
        return super.equals(obj);
    }

    private boolean compare(String a, String b) {
        if (a == null && b == null) {
            return true;
        }
        if (a != null) {
            return a.equals(b);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.storageSignature.hashCode() ^ this.storageType.hashCode();
    }

    @Override
    public String toString() {
        return String.format("%s>%s:%s", this.getHostname(), this.getComponentSignature(), this.storageSignature);
    }
}

