/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.architecture.recovery.storage;

import kieker.analysis.architecture.recovery.events.DataflowEvent;
import kieker.analysis.architecture.recovery.events.OperationEvent;
import kieker.analysis.architecture.recovery.events.StorageEvent;
import kieker.analysis.architecture.recovery.storage.AbstractDataflowAssemblerStage;
import kieker.model.analysismodel.deployment.DeployedComponent;
import kieker.model.analysismodel.deployment.DeployedOperation;
import kieker.model.analysismodel.deployment.DeployedStorage;
import kieker.model.analysismodel.deployment.DeploymentContext;
import kieker.model.analysismodel.deployment.DeploymentModel;
import kieker.model.analysismodel.execution.EDirection;
import kieker.model.analysismodel.execution.ExecutionFactory;
import kieker.model.analysismodel.execution.ExecutionModel;
import kieker.model.analysismodel.execution.OperationDataflow;
import kieker.model.analysismodel.execution.StorageDataflow;
import kieker.model.analysismodel.execution.Tuple;
import kieker.model.analysismodel.source.SourceModel;

public class ExecutionModelDataflowAssemblerStage
extends AbstractDataflowAssemblerStage<DataflowEvent, DataflowEvent> {
    private final ExecutionModel executionModel;
    private final DeploymentModel deploymentModel;

    public ExecutionModelDataflowAssemblerStage(ExecutionModel executionModel, DeploymentModel deploymentModel, SourceModel sourceModel, String sourceLabel) {
        super(sourceModel, sourceLabel);
        this.executionModel = executionModel;
        this.deploymentModel = deploymentModel;
    }

    protected void execute(DataflowEvent element) throws Exception {
        DeploymentContext sourceContext = (DeploymentContext)this.deploymentModel.getContexts().get((Object)element.getSource().getHostname());
        DeployedComponent callerComponent = (DeployedComponent)sourceContext.getComponents().get((Object)element.getSource().getComponentSignature());
        DeploymentContext targetContext = (DeploymentContext)this.deploymentModel.getContexts().get((Object)element.getTarget().getHostname());
        DeployedComponent calleeComponent = (DeployedComponent)targetContext.getComponents().get((Object)element.getTarget().getComponentSignature());
        if (element.getSource() instanceof OperationEvent) {
            OperationEvent sourceOperationEvent = (OperationEvent)element.getSource();
            DeployedOperation sourceOperation = (DeployedOperation)callerComponent.getOperations().get((Object)sourceOperationEvent.getOperationSignature());
            if (element.getTarget() instanceof OperationEvent) {
                OperationEvent targetOperationEvent = (OperationEvent)element.getTarget();
                DeployedOperation targetOperation = (DeployedOperation)calleeComponent.getOperations().get((Object)targetOperationEvent.getOperationSignature());
                this.addOperationDataflow(sourceOperation, targetOperation, element.getDirection());
            } else if (element.getTarget() instanceof StorageEvent) {
                StorageEvent storageEvent = (StorageEvent)element.getTarget();
                DeployedStorage targetStorage = (DeployedStorage)calleeComponent.getStorages().get((Object)storageEvent.getStorageSignature());
                this.addOperationStorageDataflow(sourceOperation, targetStorage, element.getDirection());
            } else {
                this.logger.error("Unsupported dataflow target type {}", (Object)element.getTarget().getClass().getCanonicalName());
            }
        } else if (element.getSource() instanceof StorageEvent) {
            StorageEvent storageEvent = (StorageEvent)element.getSource();
            DeployedStorage sourceStorage = (DeployedStorage)callerComponent.getStorages().get((Object)storageEvent.getStorageSignature());
            if (element.getTarget() instanceof OperationEvent) {
                OperationEvent targetOperationEvent = (OperationEvent)element.getTarget();
                DeployedOperation targetOperation = (DeployedOperation)calleeComponent.getOperations().get((Object)targetOperationEvent.getOperationSignature());
                this.addOperationStorageDataflow(targetOperation, sourceStorage, this.invert(element.getDirection()));
            } else if (element.getTarget() instanceof StorageEvent) {
                this.logger.error("Storage to storage dataflow is not allowed {} -> {}", (Object)element.getSource().toString(), (Object)element.getTarget().toString());
            } else {
                this.logger.error("Unsupported dataflow target type {}", (Object)element.getTarget().getClass().getCanonicalName());
            }
        } else {
            this.logger.error("Unsupported dataflow source type {}", (Object)element.getTarget().getClass().getCanonicalName());
        }
        this.outputPort.send((Object)element);
    }

    private void addOperationDataflow(DeployedOperation sourceOperation, DeployedOperation targetOperation, EDirection direction) {
        Tuple<DeployedOperation, DeployedOperation> key = ExecutionFactory.eINSTANCE.createTuple();
        key.setFirst(sourceOperation);
        key.setSecond(targetOperation);
        this.addObjectToSource(key);
        this.createOperationDataflow(key, sourceOperation, targetOperation, direction);
    }

    private void addOperationStorageDataflow(DeployedOperation operation, DeployedStorage storage, EDirection direction) {
        Tuple<DeployedOperation, DeployedStorage> key = ExecutionFactory.eINSTANCE.createTuple();
        key.setFirst(operation);
        key.setSecond(storage);
        this.addObjectToSource(key);
        this.createStorageDataflow(key, operation, storage, direction);
    }

    private void createStorageDataflow(Tuple<DeployedOperation, DeployedStorage> key, DeployedOperation sourceOperation, DeployedStorage accessedStorage, EDirection direction) {
        StorageDataflow storageDataflow = ExecutionFactory.eINSTANCE.createStorageDataflow();
        storageDataflow.setCode(sourceOperation);
        storageDataflow.setStorage(accessedStorage);
        storageDataflow.setDirection(direction);
        this.executionModel.getStorageDataflows().put(key, (Object)storageDataflow);
        this.addObjectToSource(storageDataflow);
    }

    private void createOperationDataflow(Tuple<DeployedOperation, DeployedOperation> key, DeployedOperation sourceOperation, DeployedOperation targetOperation, EDirection direction) {
        OperationDataflow operationDataflow = ExecutionFactory.eINSTANCE.createOperationDataflow();
        operationDataflow.setCaller(sourceOperation);
        operationDataflow.setCallee(targetOperation);
        operationDataflow.setDirection(direction);
        this.executionModel.getOperationDataflows().put(key, (Object)operationDataflow);
        this.addObjectToSource(operationDataflow);
    }

    private EDirection invert(EDirection direction) {
        switch (direction) {
            case READ: {
                return EDirection.WRITE;
            }
            case WRITE: {
                return EDirection.READ;
            }
            case BOTH: {
                return EDirection.BOTH;
            }
        }
        throw new InternalError("Unknown direction type found " + direction.name());
    }
}

