/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.architecture.repository;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import kieker.analysis.architecture.repository.ModelDescriptor;
import kieker.analysis.architecture.repository.ModelRepository;
import kieker.common.exception.ConfigurationException;
import kieker.model.analysismodel.assembly.AssemblyFactory;
import kieker.model.analysismodel.assembly.AssemblyPackage;
import kieker.model.analysismodel.deployment.DeploymentFactory;
import kieker.model.analysismodel.deployment.DeploymentPackage;
import kieker.model.analysismodel.execution.ExecutionFactory;
import kieker.model.analysismodel.execution.ExecutionPackage;
import kieker.model.analysismodel.source.SourceFactory;
import kieker.model.analysismodel.source.SourcePackage;
import kieker.model.analysismodel.statistics.StatisticsFactory;
import kieker.model.analysismodel.statistics.StatisticsPackage;
import kieker.model.analysismodel.type.TypeFactory;
import kieker.model.analysismodel.type.TypePackage;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ArchitectureModelRepositoryFactory {
    public static final String TYPE_MODEL_NAME = "type-model.xmi";
    public static final String ASSEMBLY_MODEL_NAME = "assembly-model.xmi";
    public static final String DEPLOYMENT_MODEL_NAME = "deployment-model.xmi";
    public static final String EXECUTION_MODEL_NAME = "execution-model.xmi";
    public static final String STATISTICS_MODEL_NAME = "statistics-model.xmi";
    public static final String SOURCE_MODEL_NAME = "source-model.xmi";
    public static final ModelDescriptor TYPE_MODEL_DESCRIPTOR = new ModelDescriptor("type-model.xmi", TypePackage.Literals.TYPE_MODEL, TypeFactory.eINSTANCE);
    public static final ModelDescriptor ASSEMBLY_MODEL_DESCRIPTOR = new ModelDescriptor("assembly-model.xmi", AssemblyPackage.Literals.ASSEMBLY_MODEL, AssemblyFactory.eINSTANCE);
    public static final ModelDescriptor DEPLOYMENT_MODEL_DESCRIPTOR = new ModelDescriptor("deployment-model.xmi", DeploymentPackage.Literals.DEPLOYMENT_MODEL, DeploymentFactory.eINSTANCE);
    public static final ModelDescriptor EXECUTION_MODEL_DESCRIPTOR = new ModelDescriptor("execution-model.xmi", ExecutionPackage.Literals.EXECUTION_MODEL, ExecutionFactory.eINSTANCE);
    public static final ModelDescriptor STATISTICS_MODEL_DESCRIPTOR = new ModelDescriptor("statistics-model.xmi", StatisticsPackage.Literals.STATISTICS_MODEL, StatisticsFactory.eINSTANCE, false);
    public static final ModelDescriptor SOURCE_MODEL_DESCRIPTOR = new ModelDescriptor("source-model.xmi", SourcePackage.Literals.SOURCE_MODEL, SourceFactory.eINSTANCE, false);
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchitectureModelRepositoryFactory.class);

    private ArchitectureModelRepositoryFactory() {
    }

    public static ModelRepository createEmptyModelRepository(String repositoryName) {
        return new ModelRepository(repositoryName);
    }

    public static ModelRepository createModelRepository(String repositoryName, ModelDescriptor ... descriptors) {
        ModelRepository repository = ArchitectureModelRepositoryFactory.createEmptyModelRepository(repositoryName);
        for (ModelDescriptor descriptor : descriptors) {
            repository.register(descriptor, descriptor.getFactory().create(descriptor.getRootClass()));
        }
        return repository;
    }

    public static ModelRepository readModelRepository(Path inputDirectory, ModelDescriptor ... descriptors) throws ConfigurationException {
        ModelRepository repository = ArchitectureModelRepositoryFactory.createEmptyModelRepository(inputDirectory.getFileName().toString());
        Resource.Factory.Registry registry = Resource.Factory.Registry.INSTANCE;
        Map extensionToFactoryMap = registry.getExtensionToFactoryMap();
        extensionToFactoryMap.put("xmi", new XMIResourceFactoryImpl());
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        EPackage.Registry packageRegistry = resourceSet.getPackageRegistry();
        for (ModelDescriptor descriptor : descriptors) {
            EPackage ePackage = descriptor.getFactory().getEPackage();
            packageRegistry.put((Object)ePackage.getNsURI(), (Object)ePackage);
        }
        for (ModelDescriptor descriptor : descriptors) {
            ArchitectureModelRepositoryFactory.readModel((ResourceSet)resourceSet, repository, descriptor, inputDirectory);
        }
        return repository;
    }

    private static <T extends EObject> void readModel(ResourceSet resourceSet, ModelRepository repository, ModelDescriptor modelDescriptor, Path path) throws ConfigurationException {
        LOGGER.debug("Loading model {}", (Object)modelDescriptor.getFilename());
        File modelFile = ArchitectureModelRepositoryFactory.createReadModelFileHandle(path, modelDescriptor.getFilename());
        if (modelFile.exists()) {
            Resource resource = resourceSet.getResource(URI.createFileURI((String)modelFile.getAbsolutePath()), true);
            for (Resource.Diagnostic error : resource.getErrors()) {
                LOGGER.error("Error loading '{}' of {}:{}  {}", new Object[]{modelDescriptor.getFilename(), error.getLocation(), error.getLine(), error.getMessage()});
            }
            for (Resource.Diagnostic error : resource.getWarnings()) {
                LOGGER.error("Warning loading '{}' of {}:{}  {}", new Object[]{modelDescriptor.getFilename(), error.getLocation(), error.getLine(), error.getMessage()});
            }
            repository.register(modelDescriptor, (EObject)resource.getContents().get(0));
            TreeIterator iterator = resource.getAllContents();
            while (iterator.hasNext()) {
                ((EObject)iterator.next()).eCrossReferences();
            }
        } else {
            if (modelDescriptor.isRequired()) {
                LOGGER.error("Error reading model file {}. File does not exist.", (Object)modelFile.getAbsoluteFile());
                throw new ConfigurationException(String.format("Error reading model file %s. File does not exist.", modelFile.getAbsoluteFile()));
            }
            LOGGER.warn("Optional model file {} not present.", (Object)modelFile.getAbsoluteFile());
            repository.register(modelDescriptor, modelDescriptor.getFactory().create(modelDescriptor.getRootClass()));
        }
    }

    private static File createReadModelFileHandle(Path path, String filename) {
        return new File(path.toString() + File.separator + filename);
    }

    public static void writeModelRepository(Path outputDirectory, ModelRepository repository) throws IOException {
        ModelDescriptor descriptor;
        Resource.Factory.Registry registry = Resource.Factory.Registry.INSTANCE;
        Map extensionToFactoryMap = registry.getExtensionToFactoryMap();
        extensionToFactoryMap.put("xmi", new XMIResourceFactoryImpl());
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.setResourceFactoryRegistry(registry);
        EPackage.Registry packageRegistry = resourceSet.getPackageRegistry();
        for (EClass rootClass : repository.getModels().keySet()) {
            descriptor = repository.getModelDescriptor(rootClass);
            EPackage ePackage = descriptor.getFactory().getEPackage();
            packageRegistry.put((Object)ePackage.getNsURI(), (Object)ePackage);
        }
        if (!Files.exists(outputDirectory, new LinkOption[0])) {
            Files.createDirectory(outputDirectory, new FileAttribute[0]);
        }
        ArchitectureModelRepositoryFactory.writeEclipseProject(outputDirectory, repository.getName());
        for (EClass rootClass : repository.getModels().keySet()) {
            descriptor = repository.getModelDescriptor(rootClass);
            ArchitectureModelRepositoryFactory.writeModel((ResourceSet)resourceSet, outputDirectory, descriptor.getFilename(), repository.getModel(rootClass));
        }
    }

    private static void writeEclipseProject(Path outputDirectory, String name) throws IOException {
        Path projectPath = outputDirectory.resolve(".project");
        try (BufferedWriter writer = Files.newBufferedWriter(projectPath, new OpenOption[0]);){
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            writer.write("<projectDescription>\n");
            writer.write(String.format("    <name>%s</name>\n", name));
            writer.write("    <comment></comment>\n");
            writer.write("    <projects>\n");
            writer.write("    </projects>\n");
            writer.write("    <buildSpec>\n");
            writer.write("    </buildSpec>\n");
            writer.write("    <natures>\n");
            writer.write("    </natures>\n");
            writer.write("</projectDescription>\n");
            writer.close();
        }
    }

    private static <T extends EObject> void writeModel(ResourceSet resourceSet, Path outputDirectory, String filename, T model) {
        LOGGER.debug("Saving model {}", (Object)filename);
        File modelFile = ArchitectureModelRepositoryFactory.createWriteModelFileHandle(outputDirectory, filename);
        Resource resource = resourceSet.createResource(URI.createFileURI((String)modelFile.getAbsolutePath()));
        resource.getContents().add(model);
        try {
            resource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            LOGGER.error("Cannot write {} model to storage. Cause: {}", (Object)modelFile.getAbsoluteFile(), (Object)e.getLocalizedMessage());
        }
    }

    private static File createWriteModelFileHandle(Path path, String filename) {
        return new File(path.toFile().getAbsolutePath() + File.separator + filename);
    }
}

