/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.architecture.repository;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kieker.analysis.architecture.repository.ModelDescriptor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public class ModelRepository {
    private final String name;
    private final Map<EClass, EObject> models = new ConcurrentHashMap<EClass, EObject>();
    private final Map<EClass, ModelDescriptor> descriptors = new ConcurrentHashMap<EClass, ModelDescriptor>();

    public ModelRepository(String name) {
        this.name = name;
    }

    public Map<EClass, EObject> getModels() {
        return this.models;
    }

    public <T extends EObject> T getModel(EClass eClass) {
        return (T)this.models.get(eClass);
    }

    public <T extends EObject> ModelDescriptor getModelDescriptor(EClass eClass) {
        return this.descriptors.get(eClass);
    }

    public void register(ModelDescriptor descriptor, EObject value) {
        this.models.put(descriptor.getRootClass(), value);
        this.descriptors.put(descriptor.getRootClass(), descriptor);
    }

    public String getName() {
        return this.name;
    }
}

