/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.architecture.trace;

import kieker.common.util.signature.Signature;
import kieker.model.repository.SystemModelRepository;
import kieker.model.system.model.AllocationComponent;
import kieker.model.system.model.AssemblyComponent;
import kieker.model.system.model.ComponentType;
import kieker.model.system.model.Execution;
import kieker.model.system.model.ExecutionContainer;
import kieker.model.system.model.Operation;
import teetime.framework.AbstractConsumerStage;

public abstract class AbstractTraceAnalysisStage<T>
extends AbstractConsumerStage<T> {
    private volatile SystemModelRepository systemModelRepository;

    public AbstractTraceAnalysisStage(SystemModelRepository systemModelRepository) {
        this.systemModelRepository = systemModelRepository;
    }

    public static final Execution createExecutionByEntityNames(SystemModelRepository systemModelRepository, String executionContainerName, String assemblyComponentTypeName, String componentTypeName, Signature operationSignature, long traceId, String sessionId, int eoi, int ess, long tin, long tout, boolean assumed) {
        Operation op;
        String allocationComponentName = executionContainerName + "::" + assemblyComponentTypeName;
        String operationFactoryName = componentTypeName + '.' + operationSignature;
        AllocationComponent allocInst = systemModelRepository.getAllocationFactory().lookupAllocationComponentInstanceByNamedIdentifier(allocationComponentName);
        if (allocInst == null) {
            ExecutionContainer execContainer;
            AssemblyComponent assemblyComponent = systemModelRepository.getAssemblyFactory().lookupAssemblyComponentInstanceByNamedIdentifier(assemblyComponentTypeName);
            if (assemblyComponent == null) {
                ComponentType componentType = systemModelRepository.getTypeRepositoryFactory().lookupComponentTypeByNamedIdentifier(assemblyComponentTypeName);
                if (componentType == null) {
                    componentType = systemModelRepository.getTypeRepositoryFactory().createAndRegisterComponentType(assemblyComponentTypeName, assemblyComponentTypeName);
                }
                assemblyComponent = systemModelRepository.getAssemblyFactory().createAndRegisterAssemblyComponentInstance(assemblyComponentTypeName, componentType);
            }
            if ((execContainer = systemModelRepository.getExecutionEnvironmentFactory().lookupExecutionContainerByNamedIdentifier(executionContainerName)) == null) {
                execContainer = systemModelRepository.getExecutionEnvironmentFactory().createAndRegisterExecutionContainer(executionContainerName, executionContainerName);
            }
            allocInst = systemModelRepository.getAllocationFactory().createAndRegisterAllocationComponentInstance(allocationComponentName, assemblyComponent, execContainer);
        }
        if ((op = systemModelRepository.getOperationFactory().lookupOperationByNamedIdentifier(operationFactoryName)) == null) {
            op = systemModelRepository.getOperationFactory().createAndRegisterOperation(operationFactoryName, allocInst.getAssemblyComponent().getType(), operationSignature);
            allocInst.getAssemblyComponent().getType().addOperation(op);
        }
        return new Execution(op, allocInst, traceId, sessionId, eoi, ess, tin, tout, assumed);
    }

    public static final Execution createExecutionByEntityNames(SystemModelRepository systemModelRepository, String executionContainerName, String assemblyComponentTypeName, Signature operationSignature, long traceId, String sessionId, int eoi, int ess, long tin, long tout, boolean assumed) {
        return AbstractTraceAnalysisStage.createExecutionByEntityNames(systemModelRepository, executionContainerName, assemblyComponentTypeName, assemblyComponentTypeName, operationSignature, traceId, sessionId, eoi, ess, tin, tout, assumed);
    }

    protected final Execution createExecutionByEntityNames(String executionContainerName, String assemblyComponentTypeName, String componentTypeName, Signature operationSignature, long traceId, String sessionId, int eoi, int ess, long tin, long tout, boolean assumed) {
        return AbstractTraceAnalysisStage.createExecutionByEntityNames(this.systemModelRepository, executionContainerName, assemblyComponentTypeName, componentTypeName, operationSignature, traceId, sessionId, eoi, ess, tin, tout, assumed);
    }

    protected final Execution createExecutionByEntityNames(String executionContainerName, String assemblyComponentTypeName, Signature operationSignature, long traceId, String sessionId, int eoi, int ess, long tin, long tout, boolean assumed) {
        return AbstractTraceAnalysisStage.createExecutionByEntityNames(this.systemModelRepository, executionContainerName, assemblyComponentTypeName, assemblyComponentTypeName, operationSignature, traceId, sessionId, eoi, ess, tin, tout, assumed);
    }

    protected void printDebugLogMessage(String[] lines) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("");
            this.logger.debug("#");
            this.logger.debug("# Plugin: " + ((Object)((Object)this)).getClass().getName());
            for (String l : lines) {
                this.logger.debug(l);
            }
        }
    }

    protected void printErrorLogMessage(String[] lines) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("");
            this.logger.error("#");
            this.logger.error("# Plugin: " + ((Object)((Object)this)).getClass().getName());
            for (String l : lines) {
                this.logger.error(l);
            }
        }
    }

    public SystemModelRepository getSystemModelRepository() {
        return this.systemModelRepository;
    }
}

