/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.architecture.trace;

import kieker.analysis.architecture.trace.flow.TraceEventRecords;
import kieker.common.record.flow.trace.AbstractTraceEvent;
import kieker.common.record.flow.trace.TraceMetadata;
import teetime.framework.AbstractConsumerStage;

public class InvalidEventRecordTraceCounter
extends AbstractConsumerStage<TraceEventRecords> {
    private static final long TRACE_ID_IF_NONE = -1L;
    private int numTracesProcessed;
    private int numTracesFailed;
    private long lastTraceIdError = -1L;
    private final boolean logInvalidTraces;

    public InvalidEventRecordTraceCounter(boolean logInvalidTraces) {
        this.logInvalidTraces = logInvalidTraces;
    }

    protected void execute(TraceEventRecords invalidTrace) throws Exception {
        TraceMetadata traceMetadata;
        if (this.logInvalidTraces) {
            this.logger.error("Invalid trace: {}", (Object)invalidTrace);
        }
        if ((traceMetadata = invalidTrace.getTraceMetadata()) != null) {
            this.reportError(invalidTrace.getTraceMetadata().getTraceId());
        } else {
            AbstractTraceEvent[] events = invalidTrace.getTraceEvents();
            if (events != null && events.length > 0) {
                this.reportError(events[0].getTraceId());
            } else {
                this.reportError(-1L);
            }
        }
    }

    protected void onTerminating() {
        this.logger.debug("Terminating {}", (Object)((Object)((Object)this)).getClass().getCanonicalName());
        super.onTerminating();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void reportError(long traceId) {
        InvalidEventRecordTraceCounter invalidEventRecordTraceCounter = this;
        synchronized (invalidEventRecordTraceCounter) {
            this.lastTraceIdError = traceId;
            ++this.numTracesFailed;
            ++this.numTracesProcessed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getErrorCount() {
        InvalidEventRecordTraceCounter invalidEventRecordTraceCounter = this;
        synchronized (invalidEventRecordTraceCounter) {
            return this.numTracesFailed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getTotalCount() {
        InvalidEventRecordTraceCounter invalidEventRecordTraceCounter = this;
        synchronized (invalidEventRecordTraceCounter) {
            return this.numTracesProcessed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getLastTraceIdError() {
        InvalidEventRecordTraceCounter invalidEventRecordTraceCounter = this;
        synchronized (invalidEventRecordTraceCounter) {
            return this.lastTraceIdError;
        }
    }
}

