/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.architecture.trace;

import java.util.Set;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.controlflow.OperationExecutionRecord;
import kieker.common.record.flow.ITraceRecord;
import kieker.common.record.flow.trace.TraceMetadata;
import teetime.framework.OutputPort;
import teetime.stage.basic.AbstractFilter;

public class TraceIdFilter
extends AbstractFilter<IMonitoringRecord> {
    private final boolean acceptAllTraces;
    private final Set<Long> selectedTraceIds;
    private final OutputPort<IMonitoringRecord> mismatchingTraceIdOutputPort = this.createOutputPort();

    public TraceIdFilter(boolean acceptAllTraces, Set<Long> selectedTraceIds) {
        this.acceptAllTraces = acceptAllTraces;
        this.selectedTraceIds = selectedTraceIds;
    }

    protected void onTerminating() {
        this.logger.debug("Terminatiing {}", (Object)((Object)((Object)this)).getClass().getCanonicalName());
        super.onTerminating();
    }

    protected void execute(IMonitoringRecord element) throws Exception {
        if (element instanceof OperationExecutionRecord) {
            this.process((OperationExecutionRecord)element);
        } else if (element instanceof ITraceRecord) {
            this.process((ITraceRecord)element);
        } else if (element instanceof TraceMetadata) {
            this.process((TraceMetadata)element);
        }
    }

    private void process(TraceMetadata element) {
        if (this.acceptId(element.getTraceId())) {
            this.outputPort.send((Object)element);
        } else {
            this.mismatchingTraceIdOutputPort.send((Object)element);
        }
    }

    private void process(ITraceRecord element) {
        if (this.acceptId(element.getTraceId())) {
            this.outputPort.send((Object)element);
        } else {
            this.mismatchingTraceIdOutputPort.send((Object)element);
        }
    }

    private void process(OperationExecutionRecord element) {
        if (this.acceptId(element.getTraceId())) {
            this.outputPort.send((Object)element);
        } else {
            this.mismatchingTraceIdOutputPort.send((Object)element);
        }
    }

    private final boolean acceptId(long traceId) {
        return this.acceptAllTraces || this.selectedTraceIds.contains(traceId);
    }

    public OutputPort<IMonitoringRecord> getMismatchingTraceIdOutputPort() {
        return this.mismatchingTraceIdOutputPort;
    }
}

