/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.architecture.trace.aggregation;

import com.google.common.base.Equivalence;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kieker.model.analysismodel.trace.OperationCall;

public class OperationCallEquivalence
extends Equivalence<OperationCall> {
    private final boolean considerFailed;

    public OperationCallEquivalence(boolean considerFailed) {
        this.considerFailed = considerFailed;
    }

    protected boolean doEquivalent(OperationCall operationCallA, OperationCall operationCallB) {
        boolean equalsWithoutFailed;
        boolean bl = equalsWithoutFailed = Objects.equals(operationCallA.getOperation(), operationCallB.getOperation()) && operationCallA.getChildren().size() == operationCallB.getChildren().size() && this.equivalent((List<OperationCall>)operationCallA.getChildren(), (List<OperationCall>)operationCallB.getChildren());
        if (this.considerFailed) {
            return equalsWithoutFailed && operationCallA.isFailed() == operationCallB.isFailed() && Objects.equals(operationCallA.getFailedCause(), operationCallB.getFailedCause());
        }
        return equalsWithoutFailed;
    }

    protected int doHash(OperationCall operationCall) {
        List childrenHashs = operationCall.getChildren().stream().map(c -> this.hash(c)).collect(Collectors.toList());
        if (this.considerFailed) {
            return Objects.hash(operationCall.getOperation(), operationCall.isFailed(), operationCall.getFailedCause(), childrenHashs);
        }
        return Objects.hash(operationCall.getOperation(), childrenHashs);
    }

    private boolean equivalent(List<OperationCall> listA, List<OperationCall> listB) {
        if (listA.size() != listB.size()) {
            return false;
        }
        return IntStream.range(0, listA.size()).allMatch(i -> this.equivalent((OperationCall)listA.get(i), (OperationCall)listB.get(i)));
    }
}

