/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.architecture.trace.execution;

import kieker.analysis.architecture.trace.AbstractTraceAnalysisStage;
import kieker.common.record.controlflow.OperationExecutionRecord;
import kieker.common.util.signature.ClassOperationSignaturePair;
import kieker.model.repository.SystemModelRepository;
import kieker.model.system.model.Execution;
import teetime.framework.OutputPort;

public class ExecutionRecordTransformationStage
extends AbstractTraceAnalysisStage<OperationExecutionRecord> {
    private final OutputPort<Execution> outputPort = this.createOutputPort(Execution.class);

    public ExecutionRecordTransformationStage(SystemModelRepository repository) {
        super(repository);
    }

    protected void execute(OperationExecutionRecord operationExecutionRecord) throws Exception {
        String operationSignature = operationExecutionRecord.getOperationSignature();
        boolean isConstructor = operationSignature.contains("<init>");
        ClassOperationSignaturePair fqComponentNameSignaturePair = ClassOperationSignaturePair.splitOperationSignatureStr(operationExecutionRecord.getOperationSignature(), isConstructor);
        Execution execution = this.createExecutionByEntityNames(operationExecutionRecord.getHostname(), fqComponentNameSignaturePair.getFqClassname(), fqComponentNameSignaturePair.getSignature(), operationExecutionRecord.getTraceId(), operationExecutionRecord.getSessionId(), operationExecutionRecord.getEoi(), operationExecutionRecord.getEss(), operationExecutionRecord.getTin(), operationExecutionRecord.getTout(), false);
        this.outputPort.send((Object)execution);
    }

    public OutputPort<Execution> getOutputPort() {
        return this.outputPort;
    }

    protected void onTerminating() {
        this.logger.debug("Terminating {}", (Object)((Object)((Object)this)).getClass().getCanonicalName());
        super.onTerminating();
    }
}

