/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.architecture.trace.execution;

import java.util.Iterator;
import kieker.analysis.architecture.trace.execution.AbstractExecutionTraceHashContainer;
import kieker.model.system.model.Execution;
import kieker.model.system.model.ExecutionTrace;

class ExecutionTraceHashContainerAllocationEquivalence
extends AbstractExecutionTraceHashContainer {
    private final int hashcodeBuffer;

    public ExecutionTraceHashContainerAllocationEquivalence(ExecutionTrace t) {
        super(t);
        int prime = 31;
        int result = 1;
        for (Execution r : t.getTraceAsSortedExecutionSet()) {
            result = 31 * result + r.getOperation().getId();
            result = 31 * result + r.getAllocationComponent().getId();
            result = 31 * result + r.getEoi();
            result = 31 * result + r.getEss();
        }
        this.hashcodeBuffer = result;
    }

    public int hashCode() {
        return this.hashcodeBuffer;
    }

    private boolean executionsEqual(Execution r1, Execution r2) {
        if (r1 == r2) {
            return true;
        }
        if (r1 == null || r2 == null) {
            return false;
        }
        return r1.getAllocationComponent().getId() == r2.getAllocationComponent().getId() && r1.getOperation().getId() == r2.getOperation().getId() && r1.getEoi() == r2.getEoi() && r1.getEss() == r2.getEss();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof AbstractExecutionTraceHashContainer)) {
            return false;
        }
        ExecutionTrace otherTrace = ((AbstractExecutionTraceHashContainer)obj).getExecutionTrace();
        if (super.getExecutionTrace().getLength() != otherTrace.getLength()) {
            return false;
        }
        Iterator otherIterator = otherTrace.getTraceAsSortedExecutionSet().iterator();
        for (Execution r1 : super.getExecutionTrace().getTraceAsSortedExecutionSet()) {
            Execution r2;
            if (this.executionsEqual(r1, r2 = (Execution)otherIterator.next())) continue;
            return false;
        }
        return true;
    }
}

