/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.architecture.trace.flow;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kieker.analysis.architecture.trace.flow.TraceEventRecords;
import kieker.common.record.flow.IFlowRecord;
import kieker.common.record.flow.trace.AbstractTraceEvent;
import kieker.common.record.flow.trace.ConstructionEvent;
import kieker.common.record.flow.trace.TraceMetadata;
import kieker.common.record.flow.trace.operation.AfterOperationEvent;
import kieker.common.record.flow.trace.operation.AfterOperationFailedEvent;
import kieker.common.record.flow.trace.operation.BeforeOperationEvent;
import kieker.common.record.flow.trace.operation.CallOperationEvent;
import kieker.common.record.flow.trace.operation.constructor.AfterConstructorEvent;
import kieker.common.record.flow.trace.operation.constructor.AfterConstructorFailedEvent;
import kieker.common.record.flow.trace.operation.constructor.BeforeConstructorEvent;
import kieker.common.record.flow.trace.operation.constructor.object.AfterConstructorFailedObjectEvent;
import kieker.common.record.flow.trace.operation.constructor.object.AfterConstructorObjectEvent;
import kieker.common.record.flow.trace.operation.constructor.object.BeforeConstructorObjectEvent;
import kieker.common.record.flow.trace.operation.object.AfterOperationFailedObjectEvent;
import kieker.common.record.flow.trace.operation.object.AfterOperationObjectEvent;
import kieker.common.record.flow.trace.operation.object.BeforeOperationObjectEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import teetime.framework.AbstractStage;
import teetime.framework.InputPort;
import teetime.framework.OutputPort;

public abstract class AbstractEventRecordTraceReconstructionStage
extends AbstractStage {
    private final OutputPort<TraceEventRecords> validTracesOutputPort = this.createOutputPort(TraceEventRecords.class);
    private final OutputPort<TraceEventRecords> invalidTracesOutputPort = this.createOutputPort(TraceEventRecords.class);
    private final InputPort<Long> timestampsInputPort;
    private final TimeUnit timeunit;
    private final long maxTraceDuration;
    private final long maxTraceTimeout;
    private final boolean hasTimeout;
    private final boolean repairEventBasedTraces;
    private long maxEncounteredLoggingTimestamp = -1L;
    private final Map<Long, TraceBuffer> traceId2trace;

    public AbstractEventRecordTraceReconstructionStage(TimeUnit timeUnit, boolean repairEventBasedTraces, long maxTraceDuration, long maxTraceTimeout) {
        this.timeunit = timeUnit;
        this.repairEventBasedTraces = repairEventBasedTraces;
        this.maxTraceDuration = this.timeunit.convert(maxTraceDuration, timeUnit);
        this.maxTraceTimeout = this.timeunit.convert(maxTraceTimeout, timeUnit);
        this.hasTimeout = this.maxTraceTimeout != Long.MAX_VALUE || this.maxTraceDuration != Long.MAX_VALUE;
        this.timestampsInputPort = this.hasTimeout ? this.createInputPort(Long.class) : null;
        this.traceId2trace = new ConcurrentHashMap<Long, TraceBuffer>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws Exception {
        Long timestamp;
        if (this.hasTimeout && (timestamp = (Long)this.timestampsInputPort.receive()) != null) {
            AbstractEventRecordTraceReconstructionStage abstractEventRecordTraceReconstructionStage = this;
            synchronized (abstractEventRecordTraceReconstructionStage) {
                if (this.hasTimeout) {
                    this.processTimeoutQueue(timestamp);
                }
            }
        }
    }

    public OutputPort<TraceEventRecords> getInvalidTracesOutputPort() {
        return this.invalidTracesOutputPort;
    }

    public OutputPort<TraceEventRecords> getValidTracesOutputPort() {
        return this.validTracesOutputPort;
    }

    public InputPort<Long> getTimestampsInputPort() {
        return this.timestampsInputPort;
    }

    protected void newFlowRecordEvent(IFlowRecord record) {
        if (record instanceof TraceMetadata) {
            this.newTraceMetadataEvent((TraceMetadata)record);
        } else if (record instanceof AbstractTraceEvent) {
            this.newAbstractTraceEvent((AbstractTraceEvent)record);
        } else {
            this.logger.error("Received illegal IFlowRecord event of type {}", record.getClass());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTrace(TraceBuffer traceBuffer, long traceId) {
        if (traceBuffer.isFinished()) {
            AbstractEventRecordTraceReconstructionStage abstractEventRecordTraceReconstructionStage = this;
            synchronized (abstractEventRecordTraceReconstructionStage) {
                this.traceId2trace.remove(traceId);
            }
            this.validTracesOutputPort.send((Object)traceBuffer.toTraceEvents());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTimeoutQueue(long loggingTimestamp) {
        if (this.hasTimeout) {
            AbstractEventRecordTraceReconstructionStage abstractEventRecordTraceReconstructionStage = this;
            synchronized (abstractEventRecordTraceReconstructionStage) {
                if (loggingTimestamp > this.maxEncounteredLoggingTimestamp) {
                    this.maxEncounteredLoggingTimestamp = loggingTimestamp;
                }
                this.processTimeoutQueue(this.maxEncounteredLoggingTimestamp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newTraceMetadataEvent(TraceMetadata record) {
        Long traceId = record.getTraceId();
        TraceBuffer traceBuffer = this.traceId2trace.get(traceId);
        if (traceBuffer == null) {
            AbstractEventRecordTraceReconstructionStage abstractEventRecordTraceReconstructionStage = this;
            synchronized (abstractEventRecordTraceReconstructionStage) {
                traceBuffer = this.traceId2trace.get(traceId);
                if (traceBuffer == null) {
                    traceBuffer = new TraceBuffer();
                    traceBuffer.setRepairEventBasedTracesEnabled(this.repairEventBasedTraces);
                    this.traceId2trace.put(traceId, traceBuffer);
                }
            }
        }
        traceBuffer.setTrace(record);
        this.handleTrace(traceBuffer, traceId);
        this.handleTimeoutQueue(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newAbstractTraceEvent(AbstractTraceEvent event) {
        Long traceId = event.getTraceId();
        TraceBuffer traceBuffer = this.traceId2trace.get(traceId);
        if (traceBuffer == null) {
            AbstractEventRecordTraceReconstructionStage abstractEventRecordTraceReconstructionStage = this;
            synchronized (abstractEventRecordTraceReconstructionStage) {
                traceBuffer = this.traceId2trace.get(traceId);
                if (traceBuffer == null) {
                    traceBuffer = new TraceBuffer();
                    traceBuffer.setRepairEventBasedTracesEnabled(this.repairEventBasedTraces);
                    this.traceId2trace.put(traceId, traceBuffer);
                }
            }
        }
        traceBuffer.insertEvent(event);
        this.handleTrace(traceBuffer, traceId);
        this.handleTimeoutQueue(event.getTimestamp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onTerminating() {
        AbstractEventRecordTraceReconstructionStage abstractEventRecordTraceReconstructionStage = this;
        synchronized (abstractEventRecordTraceReconstructionStage) {
            Collection<Long> sortedTraceIds = this.getSortedTraceIds(this.traceId2trace.keySet());
            for (Long traceId : sortedTraceIds) {
                TraceBuffer traceBuffer = this.traceId2trace.get(traceId);
                if (this.repairEventBasedTraces && !traceBuffer.getEventStack().isEmpty()) {
                    traceBuffer.repairAllBeforeEventsLeftInStackAtTermination();
                }
                if (traceBuffer.isInvalid()) {
                    this.invalidTracesOutputPort.send((Object)traceBuffer.toTraceEvents());
                    continue;
                }
                this.validTracesOutputPort.send((Object)traceBuffer.toTraceEvents());
            }
        }
        super.onTerminating();
    }

    private void processTimeoutQueue(long timestamp) {
        long duration = timestamp - this.maxTraceDuration;
        long traceTimeout = timestamp - this.maxTraceTimeout;
        Collection<Long> sortedTraceIds = this.getSortedTraceIds(this.traceId2trace.keySet());
        for (Long traceId : sortedTraceIds) {
            TraceBuffer traceBuffer = this.traceId2trace.get(traceId);
            if (traceBuffer.getMaxLoggingTimestamp() > traceTimeout && traceBuffer.getMinLoggingTimestamp() > duration) continue;
            if (traceBuffer.isInvalid()) {
                this.invalidTracesOutputPort.send((Object)traceBuffer.toTraceEvents());
            } else {
                this.validTracesOutputPort.send((Object)traceBuffer.toTraceEvents());
            }
            this.traceId2trace.remove(traceId);
        }
    }

    private Collection<Long> getSortedTraceIds(Set<Long> keys) {
        ArrayList<Long> copiedKeys = new ArrayList<Long>(keys);
        Collections.sort(copiedKeys);
        return copiedKeys;
    }

    private static final class TraceBuffer {
        private static final Logger LOGGER = LoggerFactory.getLogger(TraceBuffer.class);
        private static final Comparator<AbstractTraceEvent> COMPARATOR = new TraceEventComperator();
        private TraceMetadata trace;
        private final SortedSet<AbstractTraceEvent> events = new TreeSet<AbstractTraceEvent>(COMPARATOR);
        private boolean closeable;
        private boolean damaged;
        private int openEvents;
        private int maxOrderIndex = -1;
        private long minLoggingTimestamp = Long.MAX_VALUE;
        private long maxLoggingTimestamp = -1L;
        private long traceId = -1L;
        private boolean beforeEventStackEmptyAtTermination;
        private boolean repairEventBasedTracesEnabled;
        private final Deque<BeforeOperationEvent> beforeEventStack = new LinkedList<BeforeOperationEvent>();
        private final Deque<AbstractTraceEvent> eventQueue = new LinkedList<AbstractTraceEvent>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void insertEvent(AbstractTraceEvent event) {
            long myTraceId = event.getTraceId();
            if (this.repairEventBasedTracesEnabled) {
                if (event instanceof CallOperationEvent || event instanceof ConstructionEvent || this.beforeEventStackEmptyAtTermination) {
                    this.eventQueue.add(event);
                } else {
                    this.checkIfAfterEventsMissingThenRepair(event);
                }
            } else {
                this.eventQueue.add(event);
            }
            TraceBuffer traceBuffer = this;
            synchronized (traceBuffer) {
                while (!this.eventQueue.isEmpty()) {
                    int orderIndex;
                    AbstractTraceEvent receivedEvent = this.eventQueue.removeFirst();
                    if (this.traceId == -1L) {
                        this.traceId = myTraceId;
                    } else if (this.traceId != myTraceId) {
                        LOGGER.error("Invalid traceId! Expected: {} but found: {} in event {}", new Object[]{this.traceId, myTraceId, event.toString()});
                        this.damaged = true;
                    }
                    long loggingTimestamp = receivedEvent.getTimestamp();
                    if (loggingTimestamp > this.maxLoggingTimestamp) {
                        this.maxLoggingTimestamp = loggingTimestamp;
                    }
                    if (loggingTimestamp < this.minLoggingTimestamp) {
                        this.minLoggingTimestamp = loggingTimestamp;
                    }
                    if ((orderIndex = receivedEvent.getOrderIndex()) > this.maxOrderIndex) {
                        this.maxOrderIndex = orderIndex;
                    }
                    if (receivedEvent instanceof BeforeOperationEvent) {
                        if (orderIndex == 0) {
                            this.closeable = true;
                        }
                        ++this.openEvents;
                    } else if (receivedEvent instanceof AfterOperationEvent) {
                        --this.openEvents;
                    } else if (receivedEvent instanceof AfterOperationFailedEvent) {
                        --this.openEvents;
                    }
                    if (this.events.add(receivedEvent)) continue;
                    LOGGER.error("Duplicate entry for orderIndex {} with traceId {}", (Object)orderIndex, (Object)myTraceId);
                    this.damaged = true;
                }
            }
        }

        public void checkIfAfterEventsMissingThenRepair(AbstractTraceEvent event) {
            boolean alreadyRepairedSomeEvents;
            int orderIndex = event.getOrderIndex();
            boolean bl = alreadyRepairedSomeEvents = orderIndex <= this.maxOrderIndex;
            if (alreadyRepairedSomeEvents) {
                orderIndex = this.maxOrderIndex + 1;
            }
            if (event instanceof BeforeOperationEvent) {
                this.beforeEventStack.addLast((BeforeOperationEvent)event);
                this.eventQueue.add(event);
            } else if (event instanceof AfterOperationEvent) {
                if (this.beforeEventStack.isEmpty()) {
                    LOGGER.error("AfterEvent on empty BeforeEvent queue. {} ", (Object)event.toString());
                } else {
                    while (!this.beforeEventStack.getLast().getOperationSignature().equals(((AfterOperationEvent)event).getOperationSignature()) && !this.beforeEventStack.getLast().getClassSignature().equals(((AfterOperationEvent)event).getClassSignature())) {
                        BeforeOperationEvent beforeEvent = this.beforeEventStack.getLast();
                        String opSignature = beforeEvent.getOperationSignature();
                        String classSignature = beforeEvent.getClassSignature();
                        long timestamp = event.getTimestamp();
                        long traceID = event.getTraceId();
                        if (beforeEvent instanceof BeforeConstructorObjectEvent) {
                            this.eventQueue.add(new AfterConstructorObjectEvent(timestamp, traceID, orderIndex, opSignature, classSignature, ((BeforeConstructorObjectEvent)this.beforeEventStack.getLast()).getObjectId()));
                        } else if (beforeEvent instanceof BeforeConstructorEvent) {
                            this.eventQueue.add(new AfterConstructorEvent(timestamp, traceID, orderIndex, opSignature, classSignature));
                        } else if (beforeEvent instanceof BeforeOperationObjectEvent) {
                            this.eventQueue.add(new AfterOperationObjectEvent(timestamp, traceID, orderIndex, opSignature, classSignature, ((BeforeOperationObjectEvent)this.beforeEventStack.getLast()).getObjectId()));
                        } else {
                            this.eventQueue.add(new AfterOperationEvent(timestamp, traceID, orderIndex, opSignature, classSignature));
                        }
                        this.beforeEventStack.removeLast();
                        ++orderIndex;
                    }
                    this.beforeEventStack.removeLast();
                    if (!alreadyRepairedSomeEvents && orderIndex - 1 == this.maxOrderIndex) {
                        this.eventQueue.add(event);
                    } else {
                        String opSignature = ((AfterOperationEvent)event).getOperationSignature();
                        String classSignature = ((AfterOperationEvent)event).getClassSignature();
                        long timestamp = event.getTimestamp();
                        long traceID = event.getTraceId();
                        if (event instanceof AfterConstructorFailedObjectEvent) {
                            this.eventQueue.add(new AfterConstructorFailedObjectEvent(timestamp, traceID, orderIndex, opSignature, classSignature, ((AfterConstructorFailedObjectEvent)event).getCause(), ((AfterConstructorFailedObjectEvent)event).getObjectId()));
                        } else if (event instanceof AfterConstructorObjectEvent) {
                            this.eventQueue.add(new AfterConstructorObjectEvent(timestamp, traceID, orderIndex, opSignature, classSignature, ((AfterConstructorObjectEvent)event).getObjectId()));
                        } else if (event instanceof AfterConstructorFailedEvent) {
                            this.eventQueue.add(new AfterConstructorFailedEvent(timestamp, traceID, orderIndex, opSignature, classSignature, ((AfterConstructorFailedEvent)event).getCause()));
                        } else if (event instanceof AfterConstructorEvent) {
                            this.eventQueue.add(new AfterConstructorEvent(timestamp, traceID, orderIndex, opSignature, classSignature));
                        } else if (event instanceof AfterOperationFailedObjectEvent) {
                            this.eventQueue.add(new AfterOperationFailedObjectEvent(timestamp, traceID, orderIndex, opSignature, classSignature, ((AfterOperationFailedObjectEvent)event).getCause(), ((AfterOperationFailedObjectEvent)event).getObjectId()));
                        } else if (event instanceof AfterOperationObjectEvent) {
                            this.eventQueue.add(new AfterOperationObjectEvent(timestamp, traceID, orderIndex, opSignature, classSignature, ((AfterOperationObjectEvent)event).getObjectId()));
                        } else if (event instanceof AfterOperationFailedEvent) {
                            this.eventQueue.add(new AfterOperationFailedEvent(timestamp, traceID, orderIndex, opSignature, classSignature, ((AfterOperationFailedEvent)event).getCause()));
                        } else {
                            this.eventQueue.add(new AfterOperationEvent(timestamp, traceID, orderIndex, opSignature, classSignature));
                        }
                    }
                }
            }
        }

        public void repairAllBeforeEventsLeftInStackAtTermination() {
            this.beforeEventStackEmptyAtTermination = true;
            while (!this.beforeEventStack.isEmpty()) {
                BeforeOperationEvent beforeEvent = this.beforeEventStack.getLast();
                String opSignature = beforeEvent.getOperationSignature();
                String classSignature = beforeEvent.getClassSignature();
                long timestamp = beforeEvent.getTimestamp();
                long traceID = beforeEvent.getTraceId();
                int orderIndex = this.maxOrderIndex + 1;
                if (beforeEvent instanceof BeforeConstructorObjectEvent) {
                    this.insertEvent(new AfterConstructorObjectEvent(timestamp, traceID, orderIndex, opSignature, classSignature, ((BeforeConstructorObjectEvent)this.beforeEventStack.getLast()).getObjectId()));
                } else if (beforeEvent instanceof BeforeConstructorEvent) {
                    this.insertEvent(new AfterConstructorEvent(timestamp, traceID, orderIndex, opSignature, classSignature));
                } else if (beforeEvent instanceof BeforeOperationObjectEvent) {
                    this.insertEvent(new AfterOperationObjectEvent(timestamp, traceID, orderIndex, opSignature, classSignature, ((BeforeOperationObjectEvent)this.beforeEventStack.getLast()).getObjectId()));
                } else {
                    this.insertEvent(new AfterOperationEvent(timestamp, traceID, orderIndex, opSignature, classSignature));
                }
                this.beforeEventStack.removeLast();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setTrace(TraceMetadata trace) {
            long myTraceId = trace.getTraceId();
            TraceBuffer traceBuffer = this;
            synchronized (traceBuffer) {
                if (this.traceId == -1L) {
                    this.traceId = myTraceId;
                } else if (this.traceId != myTraceId) {
                    LOGGER.error("Invalid traceId! Expected: {} but found: {} in trace {}", new Object[]{this.traceId, myTraceId, trace.toString()});
                    this.damaged = true;
                }
                if (this.trace == null) {
                    this.trace = trace;
                } else {
                    LOGGER.error("Duplicate Trace entry for traceId {}", (Object)myTraceId);
                    this.damaged = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isFinished() {
            TraceBuffer traceBuffer = this;
            synchronized (traceBuffer) {
                return this.closeable && !this.isInvalid();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isInvalid() {
            TraceBuffer traceBuffer = this;
            synchronized (traceBuffer) {
                return this.trace == null || this.damaged || this.openEvents != 0 || this.maxOrderIndex + 1 != this.events.size() || this.events.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TraceEventRecords toTraceEvents() {
            TraceBuffer traceBuffer = this;
            synchronized (traceBuffer) {
                return new TraceEventRecords(this.trace, this.events.toArray(new AbstractTraceEvent[this.events.size()]));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getMaxLoggingTimestamp() {
            TraceBuffer traceBuffer = this;
            synchronized (traceBuffer) {
                return this.maxLoggingTimestamp;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getMinLoggingTimestamp() {
            TraceBuffer traceBuffer = this;
            synchronized (traceBuffer) {
                return this.minLoggingTimestamp;
            }
        }

        public void setRepairEventBasedTracesEnabled(boolean isEnabled) {
            this.repairEventBasedTracesEnabled = isEnabled;
        }

        public Deque<BeforeOperationEvent> getEventStack() {
            return this.beforeEventStack;
        }

        private static final class TraceEventComperator
        implements Comparator<AbstractTraceEvent>,
        Serializable {
            private static final long serialVersionUID = 8920737343446332517L;

            @Override
            public int compare(AbstractTraceEvent o1, AbstractTraceEvent o2) {
                return o1.getOrderIndex() - o2.getOrderIndex();
            }
        }
    }
}

