/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.architecture.trace.graph;

import java.util.Optional;
import kieker.analysis.architecture.trace.traversal.IOperationCallVisitor;
import kieker.analysis.generic.graph.GraphFactory;
import kieker.analysis.generic.graph.IEdge;
import kieker.analysis.generic.graph.IGraph;
import kieker.analysis.generic.graph.INode;
import kieker.analysis.util.FullyQualifiedNamesFactory;
import kieker.model.analysismodel.deployment.DeploymentContext;
import kieker.model.analysismodel.trace.OperationCall;
import kieker.model.analysismodel.type.ComponentType;
import kieker.model.analysismodel.type.OperationType;

public class GraphTransformerVisitor
implements IOperationCallVisitor {
    private final IGraph<INode, IEdge> graph;

    public GraphTransformerVisitor(IGraph<INode, IEdge> graph) {
        this.graph = graph;
    }

    @Override
    public void visit(OperationCall operationCall) {
        this.addVertex(operationCall);
        if (operationCall.getParent() != null) {
            this.addEdge(operationCall);
        } else {
            this.addRootVertex(operationCall);
        }
    }

    private INode addVertex(OperationCall operationCall) {
        INode vertex = GraphFactory.createNode(FullyQualifiedNamesFactory.createFullyQualifiedName(operationCall));
        OperationType operationType = operationCall.getOperation().getAssemblyOperation().getOperationType();
        ComponentType componentType = operationType.getComponentType();
        DeploymentContext deploymentContext = operationCall.getOperation().getComponent().getContext();
        vertex.setProperty("name", operationType.getName());
        vertex.setProperty("returnType", operationType.getReturnType());
        vertex.setProperty("modifiers", operationType.getModifiers());
        vertex.setProperty("parameterTypes", operationType.getParameterTypes());
        vertex.setProperty("component", componentType.getName());
        vertex.setProperty("package", componentType.getPackage());
        vertex.setProperty("deploymentContext", deploymentContext.getName());
        vertex.setProperty("stackDepth", operationCall.getStackDepth());
        this.graph.getGraph().addNode((Object)vertex);
        return vertex;
    }

    private IEdge addEdge(OperationCall operationCall) {
        String thisVertexId = FullyQualifiedNamesFactory.createFullyQualifiedName(operationCall);
        Optional<INode> thisVertex = this.graph.findNode(thisVertexId);
        String parentVertexId = FullyQualifiedNamesFactory.createFullyQualifiedName(operationCall.getParent());
        Optional<INode> parentVertex = this.graph.findNode(parentVertexId);
        if (!thisVertex.isPresent()) {
            throw new IllegalStateException("Target vertex not found (operationCall:" + operationCall + ").");
        }
        if (!parentVertex.isPresent()) {
            throw new IllegalStateException("Source vertex not found (operationCall:" + operationCall.getParent() + ").");
        }
        IEdge edge = GraphFactory.createEdge(null);
        edge.setProperty("orderIndex", operationCall.getOrderIndex() + 1);
        this.graph.getGraph().addEdge((Object)parentVertex.get(), (Object)thisVertex.get(), (Object)edge);
        return edge;
    }

    private INode addRootVertex(OperationCall rootOperationCall) {
        String rootVertexId = FullyQualifiedNamesFactory.createFullyQualifiedName(rootOperationCall);
        Optional<INode> rootVertex = this.graph.findNode(rootVertexId);
        if (!rootVertex.isPresent()) {
            throw new IllegalStateException("Root vertex not found (operationCall:" + rootOperationCall + ").");
        }
        INode entryVertex = GraphFactory.createNode("'Entry'");
        entryVertex.setProperty("artificial", true);
        entryVertex.setProperty("name", "'Entry'");
        IEdge edge = GraphFactory.createEdge(null);
        edge.setProperty("orderIndex", 1);
        this.graph.getGraph().addEdge((Object)entryVertex, (Object)rootVertex.get(), (Object)edge);
        return entryVertex;
    }
}

