/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.architecture.trace.sink;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import kieker.analysis.architecture.trace.AbstractTraceProcessingStage;
import kieker.model.repository.SystemModelRepository;
import kieker.model.system.model.InvalidExecutionTrace;

public class InvalidExecutionTraceWriterSink
extends AbstractTraceProcessingStage<InvalidExecutionTrace> {
    private static final String ENCODING = "UTF-8";
    private final PrintStream printStream;
    private final String outputFilename;

    public InvalidExecutionTraceWriterSink(SystemModelRepository repository, File outputFile) throws IOException {
        super(repository);
        this.printStream = new PrintStream(Files.newOutputStream(outputFile.toPath(), new OpenOption[0]), false, ENCODING);
        this.outputFilename = outputFile.getCanonicalPath();
    }

    protected void execute(InvalidExecutionTrace element) throws Exception {
        this.printStream.println(element.getInvalidExecutionTraceArtifacts().toString());
        this.reportSuccess(element.getInvalidExecutionTraceArtifacts().getTraceId());
    }

    @Override
    public void printStatusMessage() {
        super.printStatusMessage();
        int numTraces = this.getSuccessCount();
        this.logger.debug("Wrote {} execution trace artifact{} to file '{}'", new Object[]{numTraces, numTraces > 1 ? "s" : "", this.outputFilename});
    }

    protected void onTerminating() {
        this.logger.debug("Terminating {}", (Object)((Object)((Object)this)).getClass().getCanonicalName());
        if (this.printStream != null) {
            this.printStream.close();
        }
        super.onTerminating();
    }
}

