/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.architecture.trace.traversal;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import kieker.analysis.architecture.trace.traversal.IOperationCallVisitor;
import kieker.model.analysismodel.trace.OperationCall;
import kieker.model.analysismodel.trace.Trace;

public class TraceTraverser {
    public void traverse(Trace trace, IOperationCallVisitor visitor) {
        Set<IOperationCallVisitor> visitors = Collections.singleton(visitor);
        this.handleOperationCallsRecursively(trace.getRootOperationCall(), visitors);
    }

    public void traverse(Trace trace, Collection<IOperationCallVisitor> visitors) {
        this.handleOperationCallsRecursively(trace.getRootOperationCall(), visitors);
    }

    private void handleOperationCallsRecursively(OperationCall operationCall, Collection<IOperationCallVisitor> visitors) {
        for (IOperationCallVisitor visitor : visitors) {
            visitor.visit(operationCall);
        }
        for (OperationCall childOperationCall : operationCall.getChildren()) {
            this.handleOperationCallsRecursively(childOperationCall, visitors);
        }
    }
}

