/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.behavior;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kieker.analysis.behavior.events.EntryCallEvent;
import kieker.common.record.flow.IFlowRecord;
import kieker.common.record.flow.trace.TraceMetadata;
import kieker.common.record.flow.trace.operation.AfterOperationEvent;
import kieker.common.record.flow.trace.operation.BeforeOperationEvent;
import kieker.common.record.flow.trace.operation.EntryLevelBeforeOperationEvent;
import teetime.stage.basic.AbstractTransformation;

public class CreateEntryLevelEventStage
extends AbstractTransformation<IFlowRecord, EntryCallEvent> {
    private final Map<Long, TraceMetadata> registeredTraces = new ConcurrentHashMap<Long, TraceMetadata>();
    private final Map<Long, BeforeOperationEvent> registeredBeforeOperationEvents = new ConcurrentHashMap<Long, BeforeOperationEvent>();
    private final Map<Long, Integer> traceStackDepth = new ConcurrentHashMap<Long, Integer>();
    private final boolean waitForCompleteTrace;

    public CreateEntryLevelEventStage(boolean waitForCompleteTrace) {
        this.waitForCompleteTrace = waitForCompleteTrace;
    }

    protected void execute(IFlowRecord element) throws Exception {
        if (element instanceof TraceMetadata) {
            this.registerTraceMetadata((TraceMetadata)element);
        } else if (this.waitForCompleteTrace) {
            this.processCompleteTrace(element);
        } else {
            this.processBeforeOperationOnlyTrace(element);
        }
    }

    private void processCompleteTrace(IFlowRecord element) {
        if (element instanceof BeforeOperationEvent) {
            BeforeOperationEvent beforeOperationEvent = (BeforeOperationEvent)element;
            long traceId = beforeOperationEvent.getTraceId();
            if (beforeOperationEvent.getOrderIndex() == 0) {
                if (this.containsTrace(traceId)) {
                    Integer value = this.traceStackDepth.get(traceId);
                    this.traceStackDepth.put(beforeOperationEvent.getTraceId(), value + 1);
                    this.registerBeforeOperationEvent(beforeOperationEvent);
                } else {
                    this.logger.error("Received BeforeOperationEvent for unknown trace {}", (Object)traceId);
                }
            } else if (this.containsTrace(traceId)) {
                Integer value = this.traceStackDepth.get(traceId);
                this.traceStackDepth.put(beforeOperationEvent.getTraceId(), value + 1);
            } else {
                this.logger.error("Received BeforeOperationEvent for unknown trace {}", (Object)traceId);
            }
        } else if (element instanceof AfterOperationEvent) {
            AfterOperationEvent afterOperationEvent = (AfterOperationEvent)element;
            long traceId = afterOperationEvent.getTraceId();
            if (this.containsTrace(traceId)) {
                if (this.checkDepth(afterOperationEvent)) {
                    this.createEntryCallEvent(afterOperationEvent);
                    this.registeredBeforeOperationEvents.remove(traceId);
                    this.registeredTraces.remove(traceId);
                    this.traceStackDepth.remove(traceId);
                }
            } else {
                this.logger.error("Received AfterOperationEvent for unknown trace {}", (Object)traceId);
            }
        }
    }

    private void processBeforeOperationOnlyTrace(IFlowRecord element) {
        BeforeOperationEvent beforeOperationEvent;
        if (element instanceof BeforeOperationEvent && (beforeOperationEvent = (BeforeOperationEvent)element).getOrderIndex() == 0) {
            long traceId = beforeOperationEvent.getTraceId();
            if (this.containsTrace(traceId)) {
                this.outputPort.send((Object)this.createEntryCallEvent(beforeOperationEvent));
                this.registeredTraces.remove(traceId);
            } else {
                this.logger.error("Received BeforeOperationEvent for unknown trace {}", (Object)traceId);
            }
        }
    }

    private boolean checkDepth(AfterOperationEvent afterOperationEvent) {
        Integer value = this.traceStackDepth.get(afterOperationEvent.getTraceId());
        return value * 2 - 1 == afterOperationEvent.getOrderIndex();
    }

    private void registerTraceMetadata(TraceMetadata traceMetadata) {
        this.registeredTraces.put(traceMetadata.getTraceId(), traceMetadata);
        this.traceStackDepth.put(traceMetadata.getTraceId(), 0);
    }

    public boolean containsTrace(Long traceId) {
        return this.registeredTraces.containsKey(traceId);
    }

    private void registerBeforeOperationEvent(BeforeOperationEvent beforeOperationEvent) {
        this.registeredBeforeOperationEvents.put(beforeOperationEvent.getTraceId(), beforeOperationEvent);
    }

    private EntryCallEvent createEntryCallEvent(BeforeOperationEvent beforeOperationEvent) {
        TraceMetadata traceMetadata = this.registeredTraces.get(beforeOperationEvent.getTraceId());
        if (beforeOperationEvent instanceof EntryLevelBeforeOperationEvent) {
            EntryLevelBeforeOperationEvent entryLevelbeforeOperationEvent = (EntryLevelBeforeOperationEvent)beforeOperationEvent;
            return new EntryCallEvent(beforeOperationEvent.getTimestamp(), beforeOperationEvent.getTimestamp(), beforeOperationEvent.getOperationSignature(), beforeOperationEvent.getClassSignature(), traceMetadata.getSessionId(), traceMetadata.getHostname(), entryLevelbeforeOperationEvent.getParameters(), entryLevelbeforeOperationEvent.getValues(), entryLevelbeforeOperationEvent.getRequestType());
        }
        return new EntryCallEvent(beforeOperationEvent.getTimestamp(), beforeOperationEvent.getTimestamp(), beforeOperationEvent.getOperationSignature(), beforeOperationEvent.getClassSignature(), traceMetadata.getSessionId(), traceMetadata.getHostname(), new String[0], new String[0], 0);
    }

    private void createEntryCallEvent(AfterOperationEvent afterOperationEvent) {
        TraceMetadata traceMetadata = this.registeredTraces.get(afterOperationEvent.getTraceId());
        BeforeOperationEvent beforeOperationEvent = this.registeredBeforeOperationEvents.get(afterOperationEvent.getTraceId());
        if (beforeOperationEvent != null) {
            if (beforeOperationEvent instanceof EntryLevelBeforeOperationEvent) {
                EntryLevelBeforeOperationEvent entryLevelbeforeOperationEvent = (EntryLevelBeforeOperationEvent)beforeOperationEvent;
                this.outputPort.send((Object)new EntryCallEvent(beforeOperationEvent.getTimestamp(), afterOperationEvent.getTimestamp(), beforeOperationEvent.getOperationSignature(), beforeOperationEvent.getClassSignature(), traceMetadata.getSessionId(), traceMetadata.getHostname(), entryLevelbeforeOperationEvent.getParameters(), entryLevelbeforeOperationEvent.getValues(), entryLevelbeforeOperationEvent.getRequestType()));
            } else {
                this.outputPort.send((Object)new EntryCallEvent(beforeOperationEvent.getTimestamp(), afterOperationEvent.getTimestamp(), beforeOperationEvent.getOperationSignature(), beforeOperationEvent.getClassSignature(), traceMetadata.getSessionId(), traceMetadata.getHostname(), new String[0], new String[0], 0));
            }
        } else {
            this.logger.error("Missing EntryLevelBeforeOperationEvent or BeforeOperationEvent found for AfterOperationEvent traceId={}, orderIndex={}", (Object)afterOperationEvent.getTraceId(), (Object)afterOperationEvent.getOrderIndex());
        }
    }
}

