/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.behavior;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kieker.analysis.behavior.events.EntryCallEvent;
import kieker.analysis.behavior.model.UserSession;
import kieker.common.record.session.ISessionEvent;
import kieker.common.record.session.SessionEndEvent;
import kieker.common.record.session.SessionStartEvent;
import teetime.framework.AbstractStage;
import teetime.framework.InputPort;
import teetime.framework.OutputPort;

public final class EntryCallSequenceStage
extends AbstractStage {
    private final Map<String, UserSession> sessions = new HashMap<String, UserSession>();
    private final OutputPort<UserSession> userSessionOutputPort = this.createOutputPort();
    private final InputPort<EntryCallEvent> entryCallInputPort = this.createInputPort();
    private final InputPort<ISessionEvent> sessionEventInputPort = this.createInputPort();
    private final Long userSessionTimeout;

    public EntryCallSequenceStage(Long userSessionTimeout) {
        this.userSessionTimeout = userSessionTimeout;
    }

    protected void execute() {
        this.processSessionEvent((ISessionEvent)this.sessionEventInputPort.receive());
        this.processEntryCallEvent((EntryCallEvent)this.entryCallInputPort.receive());
        if (this.userSessionTimeout != null) {
            this.removeExpiredSessions();
        }
    }

    private void processEntryCallEvent(EntryCallEvent event) {
        if (event != null) {
            String userSessionId = UserSession.createUserSessionId(event);
            UserSession userSession = this.sessions.get(userSessionId);
            if (userSession == null) {
                userSession = new UserSession(event.getHostname(), event.getSessionId());
                this.sessions.put(userSessionId, userSession);
                this.logger.warn("Received an entry call event with an unknown session id {}", (Object)event.getSessionId());
            }
            userSession.add(event, true);
        }
    }

    private void processSessionEvent(ISessionEvent sessionEvent) {
        if (sessionEvent != null) {
            if (sessionEvent instanceof SessionStartEvent) {
                this.processSessionStartEvent((SessionStartEvent)sessionEvent);
            }
            if (sessionEvent instanceof SessionEndEvent) {
                this.processSessionEndEvent((SessionEndEvent)sessionEvent);
            }
        }
    }

    private void processSessionStartEvent(SessionStartEvent sessionEvent) {
        this.sessions.put(UserSession.createUserSessionId(sessionEvent), new UserSession(sessionEvent.getHostname(), sessionEvent.getSessionId()));
    }

    private void processSessionEndEvent(SessionEndEvent sessionEvent) {
        UserSession session = this.sessions.get(UserSession.createUserSessionId(sessionEvent));
        if (session != null) {
            this.userSessionOutputPort.send((Object)session);
            this.sessions.remove(sessionEvent.getSessionId());
        }
    }

    private void removeExpiredSessions() {
        long timeNow = System.currentTimeMillis() * 1000000L;
        HashSet<String> sessionsToRemove = new HashSet<String>();
        for (String sessionId : this.sessions.keySet()) {
            UserSession session = this.sessions.get(sessionId);
            long exitTime = session.getExitTime();
            boolean isExpired = exitTime + this.userSessionTimeout < timeNow;
            if (!isExpired) continue;
            this.userSessionOutputPort.send((Object)session);
            sessionsToRemove.add(sessionId);
        }
        for (String sessionId : sessionsToRemove) {
            this.sessions.remove(sessionId);
        }
    }

    public void onTerminating() {
        for (UserSession session : this.sessions.values()) {
            this.userSessionOutputPort.send((Object)session);
        }
        super.onTerminating();
    }

    public OutputPort<UserSession> getUserSessionOutputPort() {
        return this.userSessionOutputPort;
    }

    public InputPort<EntryCallEvent> getEntryCallInputPort() {
        return this.entryCallInputPort;
    }

    public InputPort<ISessionEvent> getSessionEventInputPort() {
        return this.sessionEventInputPort;
    }
}

