/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.behavior;

import com.google.common.graph.MutableNetwork;
import com.google.common.graph.NetworkBuilder;
import java.util.List;
import java.util.Optional;
import kieker.analysis.behavior.events.EntryCallEvent;
import kieker.analysis.behavior.model.UserBehaviorEdge;
import kieker.analysis.behavior.model.UserSession;
import kieker.analysis.generic.graph.IGraph;
import kieker.analysis.generic.graph.INode;
import kieker.analysis.generic.graph.impl.GraphImpl;
import kieker.analysis.generic.graph.impl.NodeImpl;
import teetime.stage.basic.AbstractTransformation;

public class UserSessionToBehaviorModelTransformation
extends AbstractTransformation<UserSession, IGraph<INode, UserBehaviorEdge>> {
    protected void execute(UserSession session) throws Exception {
        this.logger.info("Received user session");
        session.sortEventsBy(UserSession.SORT_ENTRY_CALL_EVENTS_BY_ENTRY_TIME);
        List<EntryCallEvent> entryCalls = session.getEvents();
        this.outputPort.send(new GraphImpl<INode, UserBehaviorEdge>(session.getSessionId(), this.eventsToModel(entryCalls)));
        this.logger.debug("Created BehaviorModel");
    }

    public MutableNetwork<INode, UserBehaviorEdge> eventsToModel(List<EntryCallEvent> events) {
        MutableNetwork model = NetworkBuilder.directed().allowsSelfLoops(true).build();
        INode currentNode = new NodeImpl("Init");
        model.addNode((Object)currentNode);
        NodeImpl lastNode = currentNode;
        for (EntryCallEvent event : events) {
            Optional<INode> currentNodeOptional = this.findNode((MutableNetwork<INode, UserBehaviorEdge>)model, event.getOperationSignature());
            if (!currentNodeOptional.isPresent()) {
                currentNode = new NodeImpl(event.getOperationSignature());
                model.addNode((Object)currentNode);
            } else {
                currentNode = currentNodeOptional.get();
            }
            this.addEdge(event, (MutableNetwork<INode, UserBehaviorEdge>)model, lastNode, currentNode);
            lastNode = currentNode;
        }
        return model;
    }

    private Optional<INode> findNode(MutableNetwork<INode, UserBehaviorEdge> model, String signature) {
        return model.nodes().stream().filter(node -> node.getId().equals(signature)).findFirst();
    }

    public void addEdge(EntryCallEvent event, MutableNetwork<INode, UserBehaviorEdge> model, INode source, INode target) {
        Optional matchingEdgeOptional = model.edgeConnecting((Object)source, (Object)target);
        if (!matchingEdgeOptional.isPresent()) {
            model.addEdge((Object)source, (Object)target, (Object)new UserBehaviorEdge(source.getId() + ":" + target.getId(), event));
        } else {
            ((UserBehaviorEdge)matchingEdgeOptional.get()).addEvent(event);
        }
    }
}

