/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.behavior.acceptance.matcher;

import java.util.List;
import java.util.regex.Pattern;
import kieker.analysis.behavior.acceptance.matcher.EAcceptanceMode;
import kieker.analysis.behavior.acceptance.matcher.IEntryCallAcceptanceMatcher;
import kieker.analysis.behavior.events.EntryCallEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericEntryCallAcceptanceMatcher
implements IEntryCallAcceptanceMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericEntryCallAcceptanceMatcher.class);
    private final List<Pattern> classPatterns;
    private final List<Pattern> operationPatterns;
    private final EAcceptanceMode mode;

    public GenericEntryCallAcceptanceMatcher(List<Pattern> classPatterns, List<Pattern> operationPatterns, EAcceptanceMode mode) {
        this.classPatterns = classPatterns;
        this.operationPatterns = operationPatterns;
        this.mode = mode;
    }

    @Override
    public boolean match(EntryCallEvent call) {
        if (this.mode == EAcceptanceMode.INVERSE) {
            return this.inverseMatch(call.getClassSignature(), this.classPatterns) && this.inverseMatch(call.getOperationSignature(), this.operationPatterns);
        }
        return this.match(call.getClassSignature(), this.classPatterns) && this.match(call.getOperationSignature(), this.operationPatterns);
    }

    private boolean match(String signature, List<Pattern> patterns) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(signature).matches()) continue;
            return true;
        }
        LOGGER.debug("Discarded signature {}", (Object)signature);
        return false;
    }

    private boolean inverseMatch(String signature, List<Pattern> patterns) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(signature).matches()) continue;
            return false;
        }
        return true;
    }
}

