/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.behavior.clustering;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import kieker.analysis.behavior.clustering.IParameterWeighting;
import kieker.analysis.behavior.events.EntryCallEvent;
import kieker.analysis.behavior.model.EventGroup;
import kieker.analysis.behavior.model.UserBehaviorEdge;
import kieker.analysis.generic.graph.INode;
import kieker.analysis.generic.graph.clustering.BasicCostFunction;

public class UserBehaviorCostFunction
extends BasicCostFunction<INode, UserBehaviorEdge> {
    private final double eventGroupInsertCost;
    private final IParameterWeighting weighting;

    public UserBehaviorCostFunction(double nodeInsertionCost, double edgeInsertionCost, double eventGroupInsertCost, IParameterWeighting parameterWeighting) {
        super(nodeInsertionCost, edgeInsertionCost);
        this.eventGroupInsertCost = eventGroupInsertCost;
        this.weighting = parameterWeighting;
    }

    @Override
    public double computeEdgeInsertionCost(UserBehaviorEdge edge) {
        double distance = super.computeEdgeInsertionCost(edge);
        for (EventGroup eventGroup : edge.getEventGroups()) {
            distance += this.eventGroupInsertionCost(eventGroup);
        }
        return distance;
    }

    @Override
    public double edgeAnnotationDistance(UserBehaviorEdge edge1, UserBehaviorEdge edge2) {
        boolean success;
        double distance = super.edgeAnnotationDistance(edge1, edge2);
        for (EventGroup eventGroup1 : edge1.getEventGroups()) {
            success = false;
            for (EventGroup eventGroup2 : edge2.getEventGroups()) {
                if (!eventGroup1.hasSameParameters(eventGroup2)) continue;
                distance += this.eventGroupDistance(eventGroup1, eventGroup2);
                success = true;
                break;
            }
            if (success) continue;
            distance += this.eventGroupInsertionCost(eventGroup1);
        }
        for (EventGroup eventGroup2 : edge2.getEventGroups()) {
            success = false;
            for (EventGroup eventGroup1 : edge1.getEventGroups()) {
                if (!eventGroup1.hasSameParameters(eventGroup2)) continue;
                success = true;
                break;
            }
            if (success) continue;
            distance += this.eventGroupInsertionCost(eventGroup2);
        }
        return distance;
    }

    private double eventGroupDistance(EventGroup eventGroup1, EventGroup eventGroup2) {
        double distance = 0.0;
        LinkedList<EntryCallEvent> unvisitedEvents1 = new LinkedList<EntryCallEvent>(eventGroup1.getEvents());
        LinkedList<EntryCallEvent> unvisitedEvents2 = new LinkedList<EntryCallEvent>(eventGroup2.getEvents());
        while (!unvisitedEvents1.isEmpty()) {
            ArrayList<EntryCallEvent> matches1 = new ArrayList<EntryCallEvent>();
            ArrayList<EntryCallEvent> matches2 = new ArrayList<EntryCallEvent>();
            EntryCallEvent event = (EntryCallEvent)unvisitedEvents1.poll();
            matches1.add(event);
            for (EntryCallEvent potentialMatch : unvisitedEvents1) {
                if (!this.haveSameValues(event, potentialMatch)) continue;
                matches1.add(potentialMatch);
            }
            unvisitedEvents1.removeAll(matches1);
            for (EntryCallEvent potentialMatch : unvisitedEvents2) {
                if (!this.haveSameValues(event, potentialMatch)) continue;
                matches2.add(potentialMatch);
            }
            unvisitedEvents2.removeAll(matches2);
            if (matches2.isEmpty()) {
                distance += this.weighting.getInsertCost(event.getParameters());
                distance += this.weighting.getDuplicateCost(event.getParameters()) * (double)(matches1.size() - 1);
                continue;
            }
            int amountDifference = Math.abs(matches1.size() - matches2.size());
            distance += this.weighting.getDuplicateCost(event.getParameters()) * (double)amountDifference;
        }
        while (!unvisitedEvents2.isEmpty()) {
            EntryCallEvent event1 = (EntryCallEvent)unvisitedEvents2.poll();
            ArrayList<EntryCallEvent> equalEvents = new ArrayList<EntryCallEvent>();
            for (EntryCallEvent event2 : unvisitedEvents2) {
                if (!this.haveSameValues(event1, event2)) continue;
                equalEvents.add(event2);
            }
            unvisitedEvents2.removeAll(equalEvents);
            distance += (double)equalEvents.size() * this.weighting.getDuplicateCost(event1.getParameters());
            distance += this.weighting.getInsertCost(event1.getParameters());
        }
        return distance;
    }

    private double eventGroupInsertionCost(EventGroup eventGroup) {
        double distance = this.eventGroupInsertCost;
        LinkedList<EntryCallEvent> queue = new LinkedList<EntryCallEvent>(eventGroup.getEvents());
        ArrayList<EntryCallEvent> equalEvents = new ArrayList<EntryCallEvent>();
        while (!queue.isEmpty()) {
            EntryCallEvent event1 = (EntryCallEvent)queue.poll();
            for (EntryCallEvent event2 : queue) {
                if (!this.haveSameValues(event1, event2)) continue;
                equalEvents.add(event2);
            }
            queue.removeAll(equalEvents);
            distance += (double)equalEvents.size() * this.weighting.getDuplicateCost(event1.getParameters());
            distance += this.weighting.getInsertCost(event1.getParameters());
        }
        return distance;
    }

    private boolean haveSameValues(EntryCallEvent event1, EntryCallEvent event2) {
        return Arrays.equals(event1.getValues(), event2.getValues());
    }
}

