/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.behavior.events;

public class EntryCallEvent {
    private final long entryTime;
    private final long exitTime;
    private String operationSignature;
    private String classSignature;
    private final String sessionId;
    private final String hostname;
    private final String[] parameters;
    private final String[] values;
    private final int requestType;

    public EntryCallEvent(long entryTime, long exitTime, String operationSignature, String classSignature, String sessionId, String hostname, String[] parameters, String[] values, int requestType) {
        this.entryTime = entryTime;
        this.exitTime = exitTime;
        this.operationSignature = operationSignature;
        this.classSignature = classSignature;
        this.sessionId = sessionId;
        this.hostname = hostname;
        this.parameters = parameters;
        this.values = values;
        this.requestType = requestType;
    }

    public String getOperationSignature() {
        return this.operationSignature;
    }

    public void setOperationSignature(String operationSignature) {
        this.operationSignature = operationSignature;
    }

    public String getClassSignature() {
        return this.classSignature;
    }

    public void setClassSignature(String classSignature) {
        this.classSignature = classSignature;
    }

    public long getEntryTime() {
        return this.entryTime;
    }

    public long getExitTime() {
        return this.exitTime;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public String[] getValues() {
        return this.values;
    }

    public int getRequestType() {
        return this.requestType;
    }

    public boolean equals(Object obj) {
        if (this.getClass().equals(obj.getClass())) {
            EntryCallEvent otherCall = (EntryCallEvent)obj;
            return this.compareString(this.classSignature, otherCall.classSignature) && this.compareString(this.operationSignature, otherCall.operationSignature) && this.compareString(this.hostname, otherCall.hostname) && this.compareString(this.sessionId, otherCall.sessionId) && this.entryTime == otherCall.entryTime && this.exitTime == otherCall.exitTime && this.compareArray(this.parameters, otherCall.parameters) && this.compareArray(this.values, otherCall.values);
        }
        return false;
    }

    public int hashCode() {
        return (int)((long)(super.hashCode() + this.classSignature.hashCode()) + this.entryTime + this.exitTime + (long)this.hostname.hashCode() + (long)this.sessionId.hashCode());
    }

    private boolean compareArray(String[] left, String[] right) {
        if (left == null && right == null) {
            return true;
        }
        if (left != null && right != null) {
            if (left.length == right.length) {
                for (int i = 0; i < left.length; ++i) {
                    if (this.compareString(left[i], right[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean compareString(String left, String right) {
        if (left == null && right == null) {
            return true;
        }
        if (left != null) {
            return left.equals(right);
        }
        return false;
    }

    public String toString() {
        return String.format("%s::%s %d:%d -- %d @%s[%s] %s", this.classSignature, this.operationSignature, this.entryTime, this.exitTime, this.requestType, this.hostname, this.sessionId, this.parameterValues());
    }

    private String parameterValues() {
        if (this.parameters == null && this.values == null) {
            return "no-parameters";
        }
        String result = null;
        for (int i = 0; i < this.parameters.length; ++i) {
            result = result == null ? this.parameters[i] + "=" + this.values[i] : result + ", " + this.parameters[i] + "=" + this.values[i];
        }
        if (result == null) {
            return "{}";
        }
        return "{ " + result + " }";
    }
}

