/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.behavior.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kieker.analysis.behavior.events.EntryCallEvent;
import kieker.common.record.session.ISessionEvent;

public final class UserSession {
    public static final Comparator<EntryCallEvent> SORT_ENTRY_CALL_EVENTS_BY_ENTRY_TIME = new Comparator<EntryCallEvent>(){

        @Override
        public int compare(EntryCallEvent o1, EntryCallEvent o2) {
            if (o1.getEntryTime() > o2.getEntryTime()) {
                return 1;
            }
            if (o1.getEntryTime() < o2.getEntryTime()) {
                return -1;
            }
            return 0;
        }
    };
    public static final Comparator<EntryCallEvent> SORT_ENTRY_CALL_EVENTS_BY_EXIT_TIME = new Comparator<EntryCallEvent>(){

        @Override
        public int compare(EntryCallEvent o1, EntryCallEvent o2) {
            if (o1.getExitTime() > o2.getExitTime()) {
                return 1;
            }
            if (o1.getExitTime() < o2.getExitTime()) {
                return -1;
            }
            return 0;
        }
    };
    private final List<EntryCallEvent> events = new ArrayList<EntryCallEvent>();
    private final String host;
    private final String sessionId;

    public UserSession(String host, String sessionId) {
        this.host = host;
        this.sessionId = sessionId;
    }

    public String toString() {
        return this.host + "," + this.sessionId;
    }

    public void sortEventsBy(Comparator<EntryCallEvent> cmp) {
        Collections.sort(this.events, cmp);
    }

    public void add(EntryCallEvent event) {
        this.events.add(event);
    }

    public void add(EntryCallEvent event, boolean sortByEntryTime) {
        this.add(event);
        if (sortByEntryTime) {
            this.sortEventsBy(SORT_ENTRY_CALL_EVENTS_BY_ENTRY_TIME);
        }
    }

    public Iterator<EntryCallEvent> iterator() {
        return this.events.iterator();
    }

    public int size() {
        return this.events.size();
    }

    public static String createUserSessionId(EntryCallEvent event) {
        return event.getHostname() + "," + event.getSessionId();
    }

    public static String createUserSessionId(ISessionEvent event) {
        return event.getHostname() + "," + event.getSessionId();
    }

    public long getExitTime() {
        long exitTime = 0L;
        if (this.events.size() > 0) {
            this.sortEventsBy(SORT_ENTRY_CALL_EVENTS_BY_EXIT_TIME);
            exitTime = this.events.get(this.events.size() - 1).getExitTime();
        }
        return exitTime;
    }

    public long getEntryTime() {
        long entryTime = 0L;
        if (this.events.size() > 0) {
            this.sortEventsBy(SORT_ENTRY_CALL_EVENTS_BY_ENTRY_TIME);
            entryTime = this.events.get(this.events.size() - 1).getEntryTime();
        }
        return entryTime;
    }

    public List<EntryCallEvent> getEvents() {
        return this.events;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getHost() {
        return this.host;
    }

    public int hashCode() {
        int eventHash = this.events.hashCode();
        for (EntryCallEvent event : this.events) {
            eventHash += event.hashCode();
        }
        return super.hashCode() + this.host.hashCode() + this.sessionId.hashCode() + (int)this.getEntryTime() + (int)this.getExitTime() + eventHash;
    }

    public boolean equals(Object obj) {
        if (this.getClass().equals(obj.getClass())) {
            if (this == obj) {
                return true;
            }
            UserSession otherSession = (UserSession)obj;
            return this.compareString(this.host, otherSession.host) && this.compareString(this.sessionId, otherSession.sessionId) && this.compareEvents(this.events, otherSession.events);
        }
        return false;
    }

    private boolean compareEvents(List<EntryCallEvent> left, List<EntryCallEvent> right) {
        if (left.size() == right.size()) {
            for (int i = 0; i < left.size(); ++i) {
                if (left.get(i).equals(right.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean compareString(String left, String right) {
        if (left == null && right == null) {
            return true;
        }
        if (left != null) {
            return left.equals(right);
        }
        return false;
    }
}

