/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.code;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kieker.analysis.code.data.CallerCalleeEntry;
import teetime.framework.OutputPort;
import teetime.stage.basic.AbstractFilter;

public class CallerCalleeFixPathStage
extends AbstractFilter<CallerCalleeEntry> {
    private final Map<String, String> operationToFileMap = new HashMap<String, String>();
    private final OutputPort<String> missingOperationOutputPort = this.createOutputPort(String.class);
    private final List<String> missingOperationNames = new ArrayList<String>();

    public CallerCalleeFixPathStage(List<Path> functionMapPaths, String splitSymbol) throws IOException {
        for (Path functionMapPath : functionMapPaths) {
            BufferedReader reader = Files.newBufferedReader(functionMapPath);
            try {
                String line;
                reader.readLine();
                while ((line = reader.readLine()) != null) {
                    String[] values = line.split(splitSymbol);
                    if (values.length < 2) continue;
                    this.operationToFileMap.put(values[1].trim(), values[0].trim());
                }
            }
            finally {
                if (reader == null) continue;
                reader.close();
            }
        }
    }

    protected void execute(CallerCalleeEntry element) throws Exception {
        if ("".equals(element.getSourcePath())) {
            element.setSourcePath(this.findPath(element.getCaller()));
        }
        if ("".equals(element.getTargetPath())) {
            element.setTargetPath(this.findPath(element.getCallee()));
        }
        this.outputPort.send((Object)element);
    }

    private String findPath(String functionName) {
        String path = this.operationToFileMap.get(functionName);
        if (path == null) {
            if (!this.missingOperationNames.contains(functionName)) {
                this.logger.warn("Missing file entry for operation: {}", (Object)functionName);
                this.missingOperationNames.add(functionName);
                this.missingOperationOutputPort.send((Object)functionName);
            }
            return "";
        }
        return path;
    }

    public OutputPort<String> getMissingOperationOutputPort() {
        return this.missingOperationOutputPort;
    }
}

