/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic;

import kieker.common.record.IMonitoringRecord;
import teetime.framework.AbstractStage;
import teetime.framework.InputPort;
import teetime.framework.OutputPort;

public class AnalysisThroughputStage
extends AbstractStage {
    private final InputPort<IMonitoringRecord> recordsInputPort = this.createInputPort();
    private final InputPort<Long> timestampsInputPort = this.createInputPort();
    private final OutputPort<IMonitoringRecord> recordsOutputPort = this.createOutputPort();
    private final OutputPort<Double> throughputOutputPort = this.createOutputPort();
    private long numPassedElements;
    private long lastTimestampInNs;

    protected void execute() {
        Long timestampInNs;
        IMonitoringRecord record = (IMonitoringRecord)this.recordsInputPort.receive();
        if (record != null) {
            ++this.numPassedElements;
            this.recordsOutputPort.send((Object)record);
        }
        if ((timestampInNs = (Long)this.timestampsInputPort.receive()) != null) {
            long duration = timestampInNs - this.lastTimestampInNs;
            this.throughputOutputPort.send((Object)((double)this.numPassedElements / (double)duration));
            this.numPassedElements = 0L;
            this.resetTimestamp(timestampInNs);
        }
    }

    protected void onStarting() {
        super.onStarting();
        this.resetTimestamp(System.nanoTime());
    }

    private void resetTimestamp(Long timestampInNs) {
        this.numPassedElements = 0L;
        this.lastTimestampInNs = timestampInNs;
    }

    public InputPort<IMonitoringRecord> getRecordsInputPort() {
        return this.recordsInputPort;
    }

    public InputPort<Long> getTimestampsInputPort() {
        return this.timestampsInputPort;
    }

    public OutputPort<IMonitoringRecord> getRecordsOutputPort() {
        return this.recordsOutputPort;
    }

    public OutputPort<Double> getThroughputOutputPort() {
        return this.throughputOutputPort;
    }
}

