/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic;

import java.util.ArrayList;
import java.util.List;
import kieker.analysis.generic.IControlEventMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import teetime.framework.AbstractStage;
import teetime.framework.InputPort;
import teetime.framework.OutputPort;

public class ControlledEventReleaseStage<C, B>
extends AbstractStage {
    private static final Logger LOGGER = LoggerFactory.getLogger(ControlledEventReleaseStage.class);
    private final InputPort<C> controlInputPort = this.createInputPort();
    private final InputPort<B> baseInputPort = this.createInputPort();
    private final OutputPort<B> outputPort = this.createOutputPort();
    private final List<B> storedBaseEvents = new ArrayList<B>();
    private final List<C> storedControlEvents = new ArrayList<C>();
    private final IControlEventMatcher<C, B> matcher;

    public ControlledEventReleaseStage(IControlEventMatcher<C, B> matcher) {
        this.matcher = matcher;
    }

    protected void execute() throws Exception {
        Object base;
        Object control = this.controlInputPort.receive();
        if (control != null) {
            this.stackControlOrCheckBase(control);
        }
        if ((base = this.baseInputPort.receive()) != null) {
            this.storeOrRelease(base);
        }
    }

    private void stackControlOrCheckBase(C control) {
        LOGGER.info("SCOCB stack control or check base {}", (Object)control.toString());
        for (B element : this.storedBaseEvents) {
            if (!this.matcher.checkControlEvent(control, element)) continue;
            this.storedBaseEvents.remove(element);
            this.outputPort.send(element);
            LOGGER.info("SCOCB PASS {}", (Object)element.toString());
            return;
        }
        LOGGER.info("SCOCB STACK control {}", (Object)control.toString());
        this.storedControlEvents.add(control);
    }

    private void storeOrRelease(B base) {
        LOGGER.info("SOR store or release {}", (Object)base.toString());
        if (this.matcher.requiresControlEvent(base)) {
            for (C control : this.storedControlEvents) {
                if (!this.matcher.checkControlEvent(control, base)) continue;
                if (!this.matcher.keepControlEvent(base)) {
                    this.storedControlEvents.remove(control);
                    LOGGER.info("SOR REMOVE control {}", (Object)control.toString());
                } else {
                    LOGGER.info("SOR KEEP control {}", (Object)control.toString());
                }
                this.outputPort.send(base);
                LOGGER.info("SOR RELEASE base", (Object)base.toString());
                return;
            }
        } else {
            LOGGER.info("SOR PASS without control", (Object)base.toString());
            this.outputPort.send(base);
        }
    }

    public InputPort<C> getControlInputPort() {
        return this.controlInputPort;
    }

    public InputPort<B> getBaseInputPort() {
        return this.baseInputPort;
    }

    public OutputPort<B> getOutputPort() {
        return this.outputPort;
    }
}

