/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic;

import java.util.concurrent.atomic.AtomicLong;
import teetime.framework.AbstractConsumerStage;
import teetime.framework.OutputPort;

public final class CountingStage<T>
extends AbstractConsumerStage<T> {
    private final OutputPort<T> relayedEventsOutputPort = this.createOutputPort();
    private final OutputPort<Long> countOutputPort = this.createOutputPort();
    private final AtomicLong counter = new AtomicLong();
    private final boolean echo;
    private final int modulo;
    private final String label;

    public CountingStage(boolean echo, int modulo) {
        this(echo, modulo, "");
    }

    public CountingStage(boolean echo, int modulo, String label) {
        this.echo = echo;
        this.modulo = modulo;
        this.label = label;
    }

    public final long getMessageCount() {
        return this.counter.get();
    }

    protected void execute(T event) {
        Long count = this.counter.incrementAndGet();
        if (this.echo && count % (long)this.modulo == 0L) {
            this.logger.info("Processed {} events: {}", (Object)this.label, (Object)count);
        }
        this.relayedEventsOutputPort.send(event);
        this.countOutputPort.send((Object)count);
    }

    public OutputPort<Long> getCountOutputPort() {
        return this.countOutputPort;
    }

    public OutputPort<T> getRelayedEventsOutputPort() {
        return this.relayedEventsOutputPort;
    }
}

