/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import org.csveed.api.CsvClientImpl;
import org.csveed.report.CsvException;
import teetime.stage.basic.AbstractTransformation;

public class CsvRowReaderStage<T>
extends AbstractTransformation<Path, T> {
    private final char separator;
    private final char quoteSymbol;
    private final char escapeSymbol;
    private final boolean header;
    private final Class<T> clazz;

    public CsvRowReaderStage(char separator, char quoteSymbol, char escapeSymbol, boolean header, Class<T> clazz) {
        this.separator = separator;
        this.quoteSymbol = quoteSymbol;
        this.escapeSymbol = escapeSymbol;
        this.header = header;
        this.clazz = clazz;
    }

    protected void execute(Path path) throws Exception {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            CsvClientImpl csvClient = new CsvClientImpl((Reader)reader, this.clazz);
            csvClient.setQuote(this.quoteSymbol);
            csvClient.setSeparator(this.separator);
            csvClient.setEscape(this.escapeSymbol);
            csvClient.setUseHeader(this.header);
            csvClient.skipEmptyLines(true);
            try {
                Object bean;
                while (!csvClient.isFinished() && (bean = csvClient.readBean()) != null) {
                    this.outputPort.send(bean);
                }
            }
            catch (CsvException e) {
                this.logger.error("Error reading csv file in line {} path {}", (Object)csvClient.getCurrentLine(), (Object)path.toString());
            }
        }
        catch (IOException e) {
            this.logger.error("Error reading csv file {}", (Object)path.toString());
        }
    }
}

