/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import kieker.analysis.generic.IPathLabelMapper;
import kieker.analysis.generic.Table;
import org.csveed.api.CsvClientImpl;
import org.csveed.report.CsvException;
import teetime.stage.basic.AbstractTransformation;

public class CsvTableReaderStage<R, T>
extends AbstractTransformation<Path, Table<R, T>> {
    private final char separator;
    private final char quoteSymbol;
    private final char escapeSymbol;
    private final boolean header;
    private final Class<T> clazz;
    private final IPathLabelMapper<R> mapper;

    public CsvTableReaderStage(char separator, char quoteSymbol, char escapeSymbol, boolean header, Class<T> clazz, IPathLabelMapper<R> mapper) {
        this.separator = separator;
        this.quoteSymbol = quoteSymbol;
        this.escapeSymbol = escapeSymbol;
        this.header = header;
        this.clazz = clazz;
        this.mapper = mapper;
    }

    protected void execute(Path path) throws Exception {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            CsvClientImpl csvClient = new CsvClientImpl((Reader)reader, this.clazz);
            csvClient.setQuote(this.quoteSymbol);
            csvClient.setSeparator(this.separator);
            csvClient.setEscape(this.escapeSymbol);
            csvClient.setUseHeader(this.header);
            csvClient.skipEmptyLines(true);
            Table table = new Table(this.mapper.map(path));
            try {
                Object bean;
                while (!csvClient.isFinished() && (bean = csvClient.readBean()) != null) {
                    table.getRows().add(bean);
                }
                this.outputPort.send(table);
            }
            catch (CsvException e) {
                this.logger.error("Error reading csv file in line {} path {}", (Object)csvClient.getCurrentLine(), (Object)path.toString());
            }
        }
        catch (IOException e) {
            this.logger.error("Error reading csv file {}", (Object)path.toString());
        }
    }
}

