/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kieker.analysis.generic.IEventMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import teetime.framework.AbstractConsumerStage;
import teetime.framework.OutputPort;

public class DynamicEventDispatcher
extends AbstractConsumerStage<Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicEventDispatcher.class);
    private static final int LOOP_COUNT = 1000;
    private final boolean countEvents;
    private long eventCount;
    private final Map<String, Integer> unknownRecords = new ConcurrentHashMap<String, Integer>();
    private final boolean reportUnknown;
    private final boolean outputOther;
    private final OutputPort<Object> outputOtherPort = this.createOutputPort();
    private IEventMatcher<? extends Object> rootEventMatcher;

    public DynamicEventDispatcher(IEventMatcher<? extends Object> rootEventMatcher, boolean countEvents, boolean reportUnknown, boolean outputOther) {
        this.rootEventMatcher = rootEventMatcher;
        if (rootEventMatcher != null) {
            this.assignPorts(rootEventMatcher);
        }
        this.countEvents = countEvents;
        this.reportUnknown = reportUnknown;
        this.outputOther = outputOther;
    }

    private void assignPorts(IEventMatcher<? extends Object> eventMatcher) {
        eventMatcher.setOutputPort((OutputPort<? extends Object>)this.createOutputPort());
        if (eventMatcher.getNextMatcher() != null) {
            this.assignPorts(eventMatcher.getNextMatcher());
        }
    }

    protected void execute(Object event) throws Exception {
        OutputPort<? extends Object> selectedOutputPort;
        if (this.countEvents) {
            ++this.eventCount;
        }
        if ((selectedOutputPort = this.selectOutputPort(this.rootEventMatcher, event)) != null) {
            selectedOutputPort.send(event);
        } else if (this.reportUnknown) {
            String className = event.getClass().getCanonicalName();
            Integer hits = this.unknownRecords.get(className);
            if (hits == null) {
                LOGGER.warn("Configuration error: New unknown event type {}.", (Object)className);
                this.unknownRecords.put(className, 1);
            } else {
                Integer n = hits;
                hits = hits + 1;
                this.unknownRecords.put(className, hits);
                if (hits % 1000 == 0) {
                    LOGGER.warn("Event occurances {} of unknown eventtype {}.", (Object)hits, (Object)className);
                }
            }
        }
    }

    private OutputPort<? extends Object> selectOutputPort(IEventMatcher<? extends Object> eventMatcher, Object event) {
        if (eventMatcher == null) {
            if (this.outputOther) {
                return this.outputOtherPort;
            }
            return null;
        }
        if (eventMatcher.matchEvent(event)) {
            return eventMatcher.getOutputPort();
        }
        IEventMatcher<Object> nextMatcher = eventMatcher.getNextMatcher();
        if (nextMatcher != null) {
            return this.selectOutputPort(nextMatcher, event);
        }
        if (this.outputOther) {
            return this.outputOtherPort;
        }
        return null;
    }

    public OutputPort<Object> getOutputOtherPort() {
        return this.outputOtherPort;
    }

    public long getEventCount() {
        return this.eventCount;
    }

    public void onTerminating() {
        this.logger.debug("Terminating {}", (Object)((Object)((Object)this)).getClass().getCanonicalName());
        this.logger.info("Records processed in total {}.", (Object)this.eventCount);
        super.onTerminating();
    }

    public void registerOutput(IEventMatcher<? extends Object> leaveEventMatcher) {
        leaveEventMatcher.setOutputPort((OutputPort<? extends Object>)this.createOutputPort());
        if (this.rootEventMatcher == null) {
            this.rootEventMatcher = leaveEventMatcher;
        } else {
            IEventMatcher<? extends Object> eventMatcher = this.rootEventMatcher;
            while (eventMatcher.getNextMatcher() != null) {
                eventMatcher = eventMatcher.getNextMatcher();
            }
            eventMatcher.setNextMatcher(leaveEventMatcher);
        }
    }
}

