/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import kieker.analysis.generic.IValueConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapFileReader<T, R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapFileReader.class);
    private final BufferedReader reader;
    private final Map<T, R> map;
    private final String separator;
    private final IValueConverter<T> keyConverter;
    private final IValueConverter<R> valueConverter;

    public MapFileReader(Path mapFilePath, String separator, Map<T, R> map, IValueConverter<T> keyConverter, IValueConverter<R> valueConverter) throws IOException {
        this.reader = Files.newBufferedReader(mapFilePath);
        this.separator = separator;
        this.keyConverter = keyConverter;
        this.valueConverter = valueConverter;
        this.map = map;
    }

    public void read() throws IOException {
        String line;
        while ((line = this.reader.readLine()) != null) {
            String[] values = line.split(this.separator);
            if (values.length >= 2) {
                for (int i = 0; i < values.length; ++i) {
                    values[i] = values[i].trim();
                }
                this.map.put(this.keyConverter.getColumnValue(values), this.valueConverter.getColumnValue(values));
                continue;
            }
            LOGGER.error("Entry incomplete '{}'", (Object)line.trim());
        }
        this.reader.close();
    }
}

