/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.flow.trace.operation.AfterOperationEvent;
import kieker.common.record.flow.trace.operation.BeforeOperationEvent;
import teetime.framework.AbstractConsumerStage;
import teetime.framework.OutputPort;

public class RewriteBeforeAndAfterEventsStage
extends AbstractConsumerStage<IMonitoringRecord> {
    private final OutputPort<IMonitoringRecord> outputPort = this.createOutputPort(IMonitoringRecord.class);
    private final File addrlineExecutable;
    private final Map<String, AddrOutput> addressMap = new HashMap<String, AddrOutput>();
    private final File modelExecutable;
    private final boolean caseInsensitive;

    public RewriteBeforeAndAfterEventsStage(File addrLineExecutable, File modelExecutable, boolean caseInsensitive) {
        this.addrlineExecutable = addrLineExecutable;
        this.modelExecutable = modelExecutable;
        this.caseInsensitive = caseInsensitive;
    }

    protected void execute(IMonitoringRecord element) throws Exception {
        if (element instanceof BeforeOperationEvent) {
            BeforeOperationEvent before = (BeforeOperationEvent)element;
            AddrOutput rewriteInfo = this.findRewriteInfo(before.getOperationSignature());
            this.outputPort.send((Object)new BeforeOperationEvent(before.getTimestamp(), before.getTraceId(), before.getOrderIndex(), rewriteInfo.name, rewriteInfo.filename));
        } else if (element instanceof AfterOperationEvent) {
            AfterOperationEvent before = (AfterOperationEvent)element;
            AddrOutput rewriteInfo = this.findRewriteInfo(before.getOperationSignature());
            this.outputPort.send((Object)new AfterOperationEvent(before.getTimestamp(), before.getTraceId(), before.getOrderIndex(), rewriteInfo.name, rewriteInfo.filename));
        } else {
            this.outputPort.send((Object)element);
        }
    }

    private AddrOutput findRewriteInfo(final String address) throws IOException, InterruptedException {
        AddrOutput addrOutput = this.addressMap.get(address);
        if (addrOutput == null) {
            Process process = Runtime.getRuntime().exec(String.format("%s -e %s -p -C -f %s", this.addrlineExecutable.getCanonicalPath(), this.modelExecutable, address));
            process.waitFor();
            new BufferedReader(new InputStreamReader(process.getErrorStream())).lines().forEach(new Consumer<String>(){

                @Override
                public void accept(String arg0) {
                    RewriteBeforeAndAfterEventsStage.this.logger.error("Error output from addr2line {}", (Object)arg0);
                }
            });
            new BufferedReader(new InputStreamReader(process.getInputStream())).lines().forEach(new Consumer<String>(){
                private final Pattern pattern = Pattern.compile("^([\\w.]+) at ([\\w\\?/\\.\\-]+):([\\d\\?]*)( .*)?$");

                @Override
                public void accept(String string) {
                    Matcher matcher = this.pattern.matcher(string);
                    if (matcher.find()) {
                        Integer linenumber = matcher.group(3).equals("?") ? null : Integer.valueOf(Integer.parseInt(matcher.group(3)));
                        AddrOutput addrOutput = RewriteBeforeAndAfterEventsStage.this.caseInsensitive ? new AddrOutput(matcher.group(1).toLowerCase(Locale.ROOT), matcher.group(2).toLowerCase(Locale.ROOT), linenumber) : new AddrOutput(matcher.group(1), matcher.group(2), linenumber);
                        RewriteBeforeAndAfterEventsStage.this.addressMap.put(address, addrOutput);
                    } else if ("?? ??:0".equals(string)) {
                        RewriteBeforeAndAfterEventsStage.this.addressMap.put(address, new AddrOutput(address, "++no-file++", 0));
                    } else {
                        RewriteBeforeAndAfterEventsStage.this.logger.error("Cannot process result '{}' for address {}", (Object)string, (Object)address);
                    }
                }
            });
            return this.addressMap.get(address);
        }
        return addrOutput;
    }

    public OutputPort<IMonitoringRecord> getOutputPort() {
        return this.outputPort;
    }

    private class AddrOutput {
        private final String name;
        private final String filename;
        private final Integer linenumber;

        public AddrOutput(String name, String filename, Integer linenumber) {
            this.name = name;
            this.filename = filename;
            this.linenumber = linenumber;
        }

        public String toString() {
            return String.format("%s:%d -- %s", this.filename, this.linenumber, this.name);
        }
    }
}

