/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import teetime.stage.basic.AbstractFilter;

public class TeeFilter
extends AbstractFilter<Object> {
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final boolean DEFAULT_STREAM_APPEND = true;
    private final PrintStream printStream;
    private final String printStreamName;
    private final boolean active;
    private final boolean append;
    private final String encoding;

    public TeeFilter(TeeFilterStreamType streamType, String encoding) {
        this.encoding = encoding != null ? encoding : DEFAULT_ENCODING;
        this.printStreamName = null;
        this.append = false;
        if (streamType.equals((Object)TeeFilterStreamType.STDLOG)) {
            this.printStream = null;
            this.active = true;
        } else if (streamType.equals((Object)TeeFilterStreamType.STDOUT)) {
            this.printStream = System.out;
            this.active = true;
        } else if (streamType.equals((Object)TeeFilterStreamType.STDERR)) {
            this.printStream = System.err;
            this.active = true;
        } else {
            this.printStream = null;
            this.active = false;
        }
    }

    public TeeFilter(String fileName, String encoding, boolean append) {
        PrintStream tmpPrintStream;
        this.encoding = encoding != null ? encoding : DEFAULT_ENCODING;
        this.append = append;
        try {
            tmpPrintStream = new PrintStream(Files.newOutputStream(Paths.get(fileName, new String[0]), this.append ? StandardOpenOption.APPEND : StandardOpenOption.CREATE), false, this.encoding);
        }
        catch (IOException ex) {
            this.logger.error("Failed to initialize " + fileName, (Throwable)ex);
            tmpPrintStream = null;
        }
        this.printStream = tmpPrintStream;
        this.printStreamName = fileName;
        this.active = true;
    }

    protected void onTerminating() {
        if (this.printStream != null && this.printStream != System.out && this.printStream != System.err) {
            this.printStream.close();
        }
        super.onTerminating();
    }

    protected void execute(Object object) {
        if (this.active) {
            StringBuilder sb = new StringBuilder(128).append(this.getId()).append('(').append(object.getClass().getSimpleName()).append(") ").append(object.toString());
            String record = sb.toString();
            if (this.printStream != null) {
                this.printStream.println(record);
            } else {
                this.logger.info(record);
            }
        }
        this.outputPort.send(object);
    }

    public String getPrintStreamName() {
        return this.printStreamName;
    }

    public static enum TeeFilterStreamType {
        STDLOG,
        STDOUT,
        STDERR,
        NULL;

    }
}

