/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.clustering;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import teetime.framework.AbstractConsumerStage;

public class ClusterMedoidFilesSink<T>
extends AbstractConsumerStage<T> {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Path path;
    private int clusterNumber = 0;

    public ClusterMedoidFilesSink(Path path, StdSerializer<?> ... serializers) {
        if (serializers != null) {
            SimpleModule module = new SimpleModule();
            for (StdSerializer<?> serializer : serializers) {
                module.addSerializer(serializer);
            }
            this.objectMapper.registerModule((Module)module);
        }
        this.path = path;
    }

    protected void execute(T model) throws Exception {
        Path numberedFilename = Paths.get(this.path.toString() + "_medoid_" + this.clusterNumber, new String[0]);
        ++this.clusterNumber;
        this.logger.info("Write cluster medoid to {}", (Object)numberedFilename);
        try (BufferedWriter bw = Files.newBufferedWriter(numberedFilename, new OpenOption[0]);){
            this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
            this.objectMapper.writeValue((Writer)bw, model);
        }
        catch (IOException e) {
            this.logger.error("Cannot write file {}", (Object)numberedFilename.toString());
        }
    }
}

