/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.clustering;

import kieker.analysis.generic.clustering.Clustering;
import kieker.analysis.generic.clustering.DataCollectorStage;
import kieker.analysis.generic.clustering.ExtractDBScanClustersStage;
import kieker.analysis.generic.clustering.mtree.MTreeGeneratorStage;
import kieker.analysis.generic.clustering.optics.OpticsData;
import kieker.analysis.generic.clustering.optics.OpticsStage;
import kieker.analysis.generic.graph.clustering.OPTICSDataGED;
import teetime.framework.CompositeStage;
import teetime.framework.InputPort;
import teetime.framework.OutputPort;

public class ClusteringCompositeStage<T>
extends CompositeStage {
    private final InputPort<OpticsData<T>> inputPort;
    private final InputPort<Long> timerInputPort;
    private final OutputPort<Clustering<T>> outputPort;

    public ClusteringCompositeStage(double clusteringDistance, int minPts, Integer maxAmount, OPTICSDataGED<T> distanceFunction) {
        DataCollectorStage dataCollectorStage = maxAmount != null ? new DataCollectorStage(maxAmount) : new DataCollectorStage();
        MTreeGeneratorStage<T> mTreeGeneratorStage = new MTreeGeneratorStage<T>(distanceFunction);
        OpticsStage opticsStage = new OpticsStage(clusteringDistance, minPts);
        ExtractDBScanClustersStage clustering = new ExtractDBScanClustersStage(clusteringDistance);
        this.timerInputPort = dataCollectorStage.getTimeTriggerInputPort();
        this.inputPort = dataCollectorStage.getDataInputPort();
        this.connectPorts(dataCollectorStage.getmTreeOutputPort(), mTreeGeneratorStage.getInputPort());
        this.connectPorts(mTreeGeneratorStage.getOutputPort(), opticsStage.getMTreeInputPort());
        this.connectPorts(dataCollectorStage.getOpticsOutputPort(), opticsStage.getModelsInputPort());
        this.connectPorts(opticsStage.getOutputPort(), clustering.getInputPort());
        this.outputPort = clustering.getOutputPort();
    }

    public InputPort<OpticsData<T>> getInputPort() {
        return this.inputPort;
    }

    public InputPort<Long> getTimerInputPort() {
        return this.timerInputPort;
    }

    public OutputPort<Clustering<T>> getOutputPort() {
        return this.outputPort;
    }
}

