/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.generic.clustering;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import kieker.analysis.generic.clustering.Clustering;
import teetime.framework.AbstractConsumerStage;

public class ClusteringFileSink<T>
extends AbstractConsumerStage<Clustering<T>> {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Path path;

    public ClusteringFileSink(Path path, StdSerializer<?> ... serializers) {
        if (serializers != null) {
            SimpleModule module = new SimpleModule();
            for (StdSerializer<?> serializer : serializers) {
                module.addSerializer(serializer);
            }
            this.objectMapper.registerModule((Module)module);
        }
        this.path = path;
    }

    protected void execute(Clustering<T> clustering) throws IOException {
        this.logger.info("Write models to {}", (Object)this.path.toString());
        try (BufferedWriter bw = Files.newBufferedWriter(this.path, new OpenOption[0]);){
            this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
            this.objectMapper.writeValue((Writer)bw, clustering);
        }
        catch (IOException e) {
            this.logger.error("Writing to {} failed", (Object)this.path.toString());
        }
    }
}

